/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICFileTypeResolver;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.internal.ui.preferences.CFileTypeDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CFileTypesPreferenceBlock {
    private static final int COL_PATTERN = 0;
    private static final int COL_DESCRIPTION = 1;
    private static final int COL_LANGUAGE = 2;
    private ICFileTypeResolver fResolver;
    private ArrayList fAddAssoc = new ArrayList();
    private ArrayList fRemoveAssoc = new ArrayList();
    private boolean fDirty = false;
    private TableViewer fAssocViewer;
    private Button fBtnNew;
    private Button fBtnRemove;

    public CFileTypesPreferenceBlock(ICFileTypeResolver input) {
        this.setResolver(input);
        this.setDirty(false);
    }

    public Control createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout controlLayout = new GridLayout(2, false);
        controlLayout.marginHeight = 0;
        controlLayout.marginWidth = 0;
        control.setLayout((Layout)controlLayout);
        control.setLayoutData((Object)new GridData(1808));
        Composite tablePane = new Composite(control, 0);
        GridLayout tablePaneLayout = new GridLayout();
        GridData gridData = new GridData(1808);
        tablePaneLayout.marginHeight = 0;
        tablePaneLayout.marginWidth = 0;
        tablePane.setLayout((Layout)tablePaneLayout);
        tablePane.setLayoutData((Object)gridData);
        Table table = new Table(tablePane, 68098);
        TableLayout tblLayout = new TableLayout();
        TableColumn col = null;
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = SWTUtil.getTableHeightHint(table, 25);
        gridData.widthHint = new PixelConverter((Control)parent).convertWidthInCharsToPixels(60);
        tblLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tblLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        tblLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        table.setLayout((Layout)tblLayout);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        col = new TableColumn(table, 16384);
        col.setText(PreferencesMessages.getString("CFileTypesPreferencePage.colTitlePattern"));
        col = new TableColumn(table, 16384);
        col.setText(PreferencesMessages.getString("CFileTypesPreferencePage.colTitleDescription"));
        col = new TableColumn(table, 16384);
        col.setText(PreferencesMessages.getString("CFileTypesPreferencePage.colTitleLanguage"));
        Composite buttonPane = new Composite(control, 0);
        GridLayout buttonPaneLayout = new GridLayout();
        buttonPaneLayout.marginHeight = 0;
        buttonPaneLayout.marginWidth = 0;
        buttonPane.setLayout((Layout)buttonPaneLayout);
        buttonPane.setLayoutData((Object)new GridData(2));
        this.fBtnNew = new Button(buttonPane, 8);
        this.fBtnNew.setText(PreferencesMessages.getString("CFileTypesPreferenceBlock.New..."));
        gridData = new GridData(768);
        gridData.widthHint = SWTUtil.getButtonWidthHint(this.fBtnNew);
        gridData.heightHint = SWTUtil.getButtonHeigthHint(this.fBtnNew);
        this.fBtnNew.setLayoutData((Object)gridData);
        this.fBtnNew.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CFileTypesPreferenceBlock.this.handleAdd();
            }
        });
        this.fBtnRemove = new Button(buttonPane, 8);
        this.fBtnRemove.setText(PreferencesMessages.getString("CFileTypesPreferenceBlock.Remove"));
        gridData = new GridData(768);
        gridData.widthHint = SWTUtil.getButtonWidthHint(this.fBtnRemove);
        gridData.heightHint = SWTUtil.getButtonHeigthHint(this.fBtnRemove);
        this.fBtnRemove.setLayoutData((Object)gridData);
        this.fBtnRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CFileTypesPreferenceBlock.this.handleRemove();
            }
        });
        this.fAssocViewer = new TableViewer(table);
        this.fAssocViewer.setSorter((ViewerSorter)new AssocSorter());
        this.fAssocViewer.setContentProvider((IContentProvider)new AssocContentProvider());
        this.fAssocViewer.setLabelProvider((IBaseLabelProvider)new AssocLabelProvider());
        this.fAssocViewer.setInput((Object)this.getResolver().getFileTypeAssociations());
        this.fAssocViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CFileTypesPreferenceBlock.this.handleSelectionChanged();
            }
        });
        this.handleSelectionChanged();
        return control;
    }

    public void setEnabled(boolean enabled) {
        this.fAssocViewer.getTable().setEnabled(enabled);
        this.fBtnNew.setEnabled(enabled);
        this.fBtnRemove.setEnabled(enabled);
        this.setDirty(enabled);
    }

    public void setResolver(ICFileTypeResolver resolver) {
        this.fAddAssoc.clear();
        this.fRemoveAssoc.clear();
        this.fResolver = resolver.createWorkingCopy();
        if (this.fAssocViewer != null) {
            this.fAssocViewer.setInput((Object)this.fResolver.getFileTypeAssociations());
        }
        this.setDirty(true);
    }

    public ICFileTypeResolver getResolver() {
        return this.fResolver;
    }

    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public boolean performOk() {
        boolean changed = this.fDirty;
        if (this.fDirty) {
            ICFileTypeAssociation[] add = this.fAddAssoc.toArray(new ICFileTypeAssociation[this.fAddAssoc.size()]);
            ICFileTypeAssociation[] rem = this.fRemoveAssoc.toArray(new ICFileTypeAssociation[this.fRemoveAssoc.size()]);
            this.fResolver.adjustAssociations(add, rem);
            this.fAddAssoc.clear();
            this.fRemoveAssoc.clear();
            this.setDirty(false);
        }
        return changed;
    }

    private void handleSelectionChanged() {
        IStructuredSelection sel = this.getSelection();
        this.fBtnRemove.setEnabled(!sel.isEmpty());
    }

    private IResolverModel getResolverModel() {
        return CCorePlugin.getDefault().getResolverModel();
    }

    private void handleAdd() {
        ICFileTypeAssociation assoc = null;
        CFileTypeDialog dlg = new CFileTypeDialog(this.fBtnNew.getParent().getShell());
        if (dlg.open() == 0 && (assoc = this.getResolverModel().createAssocation(dlg.getPattern(), dlg.getType())) != null) {
            this.fAssocViewer.add((Object)assoc);
            this.fAddAssoc.add(assoc);
            this.fRemoveAssoc.remove(assoc);
            this.setDirty(true);
        }
    }

    private void handleRemove() {
        IStructuredSelection sel = this.getSelection();
        if (sel != null && !sel.isEmpty()) {
            Iterator iter = sel.iterator();
            while (iter.hasNext()) {
                ICFileTypeAssociation assoc = (ICFileTypeAssociation)iter.next();
                this.fAssocViewer.remove((Object)assoc);
                this.fAddAssoc.remove(assoc);
                this.fRemoveAssoc.add(assoc);
                this.setDirty(true);
            }
        }
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.fAssocViewer.getSelection();
    }

    private class AssocSorter
    extends ViewerSorter {
        AssocSorter() {
        }

        public int category(Object element) {
            if (element instanceof ICFileTypeAssociation) {
                ICFileTypeAssociation assoc = (ICFileTypeAssociation)element;
                if (-1 != assoc.getPattern().indexOf(42)) {
                    return 10;
                }
                return 20;
            }
            return 30;
        }
    }

    private class AssocContentProvider
    implements IStructuredContentProvider {
        ICFileTypeAssociation[] assocs;

        AssocContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.assocs;
        }

        public void dispose() {
            this.assocs = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof ICFileTypeAssociation[]) {
                this.assocs = (ICFileTypeAssociation[])newInput;
            }
        }
    }

    private class AssocLabelProvider
    implements ILabelProvider,
    ITableLabelProvider {
        private ListenerList listeners = new ListenerList();

        AssocLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ICFileTypeAssociation && columnIndex == 0) {
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ICFileTypeAssociation) {
                ICFileTypeAssociation assoc = (ICFileTypeAssociation)element;
                switch (columnIndex) {
                    case 0: {
                        return assoc.getPattern();
                    }
                    case 1: {
                        return assoc.getType().getName();
                    }
                    case 2: {
                        return assoc.getType().getLanguage().getName();
                    }
                }
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void dispose() {
            this.listeners.clear();
            this.listeners = null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }
}

