/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICSharedLibrary;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class LoadSymbolsActionDelegate
implements IObjectActionDelegate {
    private ICSharedLibrary fLibrary;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.getSharedLibrary() != null) {
            final MultiStatus ms = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("LoadSymbolsActionDelegate.Unable_to_load_symbols_of_shared_library_1"), null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        LoadSymbolsActionDelegate.this.doAction(LoadSymbolsActionDelegate.this.getSharedLibrary());
                    }
                    catch (DebugException e) {
                        ms.merge(e.getStatus());
                    }
                }
            });
            if (!ms.isOK()) {
                IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    CDebugUIPlugin.errorDialog(ActionMessages.getString("LoadSymbolsActionDelegate.Operation_failed_1"), (IStatus)ms);
                } else {
                    CDebugUIPlugin.log((IStatus)ms);
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICSharedLibrary) {
            boolean enabled = this.enablesFor((ICSharedLibrary)element);
            action.setEnabled(enabled);
            if (enabled) {
                this.setSharedLibrary((ICSharedLibrary)element);
                return;
            }
        }
        action.setEnabled(false);
        this.setSharedLibrary(null);
    }

    protected void doAction(ICSharedLibrary library) throws DebugException {
        library.loadSymbols();
    }

    private boolean enablesFor(ICSharedLibrary library) {
        return library != null && !library.areSymbolsLoaded();
    }

    private void setSharedLibrary(ICSharedLibrary library) {
        this.fLibrary = library;
    }

    protected ICSharedLibrary getSharedLibrary() {
        return this.fLibrary;
    }
}

