/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Arrays;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCompletionNode;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableElement;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.internal.core.parser.ContextualParser;
import org.eclipse.cdt.internal.core.parser.token.OffsetDuple;
import org.eclipse.cdt.internal.core.parser.token.TokenFactory;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public class SelectionParser
extends ContextualParser {
    private OffsetDuple offsetRange;
    private IToken firstTokenOfDuple = null;
    private IToken lastTokenOfDuple = null;
    private IASTScope ourScope = null;
    private IASTCompletionNode.CompletionKind ourKind = null;
    private IASTNode ourContext = null;
    private ITokenDuple greaterContextDuple = null;
    private boolean pastPointOfSelection = false;
    private IASTNode contextNode = null;

    protected void handleNewToken(IToken value) {
        if (value != null && this.scanner.isOnTopContext()) {
            TraceUtil.outputTrace(this.log, "IToken provided w/offsets ", null, value.getOffset(), " & ", value.getEndOffset());
            boolean change = false;
            if (value.getOffset() == this.offsetRange.getFloorOffset()) {
                TraceUtil.outputTrace(this.log, "Offset Floor Hit w/token \"", null, value.getCharImage(), "\"", null);
                this.firstTokenOfDuple = value;
                change = true;
            }
            if (value.getEndOffset() == this.offsetRange.getCeilingOffset()) {
                TraceUtil.outputTrace(this.log, "Offset Ceiling Hit w/token \"", null, value.getCharImage(), "\"", null);
                change = true;
                this.lastTokenOfDuple = value;
            }
            if (change && this.tokenDupleCompleted()) {
                if (this.ourScope == null) {
                    this.ourScope = this.getCompletionScope();
                }
                if (this.ourContext == null) {
                    this.ourContext = this.getCompletionContext();
                }
                if (this.ourKind == null) {
                    this.ourKind = this.getCompletionKind();
                }
            }
        }
    }

    protected boolean tokenDupleCompleted() {
        return this.lastTokenOfDuple != null && this.lastTokenOfDuple.getEndOffset() >= this.offsetRange.getCeilingOffset();
    }

    public SelectionParser(IScanner scanner, ISourceElementRequestor callback, ParserLanguage language, IParserLogService log, IParserExtension extension) {
        super(scanner, callback, language, log, extension);
    }

    public IParser.ISelectionParseResult parse(int startingOffset, int endingOffset) {
        this.offsetRange = new OffsetDuple(startingOffset, endingOffset);
        this.translationUnit();
        return this.reconcileTokenDuple();
    }

    protected IParser.ISelectionParseResult reconcileTokenDuple() throws ParseError {
        if (this.firstTokenOfDuple == null || this.lastTokenOfDuple == null) {
            throw new ParseError(ParseError.ParseErrorKind.OFFSET_RANGE_NOT_NAME);
        }
        if (this.getCompletionKind() == IASTCompletionNode.CompletionKind.UNREACHABLE_CODE) {
            throw new ParseError(ParseError.ParseErrorKind.OFFSETDUPLE_UNREACHABLE);
        }
        ITokenDuple duple = TokenFactory.createTokenDuple(this.firstTokenOfDuple, this.lastTokenOfDuple);
        if (!duple.syntaxOfName()) {
            throw new ParseError(ParseError.ParseErrorKind.OFFSET_RANGE_NOT_NAME);
        }
        return this.provideSelectionNode(duple);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IParser.ISelectionParseResult provideSelectionNode(ITokenDuple duple) {
        ITokenDuple finalDuple = null;
        if (!duple.equals(this.greaterContextDuple)) {
            if (duple.getFirstToken().equals(this.greaterContextDuple.getFirstToken())) {
                finalDuple = duple;
            } else {
                if (!duple.getLastToken().equals(this.greaterContextDuple.getLastToken())) throw new ParseError(ParseError.ParseErrorKind.OFFSET_RANGE_NOT_NAME);
                finalDuple = this.greaterContextDuple;
            }
        } else {
            finalDuple = this.greaterContextDuple;
        }
        IASTNode node = this.lookupNode(finalDuple);
        if (node == null) {
            return null;
        }
        if (node instanceof IASTOffsetableNamedElement) return new SelectionParseResult((IASTOffsetableNamedElement)((Object)node), new String(((IASTOffsetableElement)((Object)node)).getFilename()));
        return null;
    }

    protected IASTNode lookupNode(ITokenDuple finalDuple) {
        if (this.contextNode == null) {
            return null;
        }
        if (this.contextNode instanceof IASTDeclaration) {
            Object[] elementQualifiedName;
            if (this.contextNode instanceof IASTOffsetableNamedElement && ((IASTOffsetableNamedElement)((Object)this.contextNode)).getName().equals(finalDuple.toString())) {
                return this.contextNode;
            }
            if (this.contextNode instanceof IASTQualifiedNameElement && Arrays.equals(elementQualifiedName = ((IASTQualifiedNameElement)((Object)this.contextNode)).getFullyQualifiedName(), finalDuple.toQualifiedName())) {
                return this.contextNode;
            }
            try {
                IASTInitializerClause initializer;
                if (this.ourKind == IASTCompletionNode.CompletionKind.NEW_TYPE_REFERENCE && this.contextNode instanceof IASTVariable && (initializer = ((IASTVariable)this.contextNode).getInitializerClause()) != null) {
                    IASTExpression ownerExpression = initializer.findExpressionForDuple(finalDuple);
                    return this.astFactory.lookupSymbolInContext(this.ourScope, finalDuple, ownerExpression);
                }
                return this.astFactory.lookupSymbolInContext(this.ourScope, finalDuple, null);
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {
                return null;
            }
        }
        if (this.contextNode instanceof IASTExpression) {
            try {
                return this.astFactory.lookupSymbolInContext(this.ourScope, finalDuple, this.contextNode);
            }
            catch (ASTNotImplementedException aSTNotImplementedException) {
                return null;
            }
        }
        return null;
    }

    public IASTCompletionNode parse(int offset) {
        throw new ParseError(ParseError.ParseErrorKind.METHOD_NOT_IMPLEMENTED);
    }

    protected void checkEndOfFile() throws EndOfFileException {
    }

    protected void setGreaterNameContext(ITokenDuple tokenDuple) {
        if (this.pastPointOfSelection) {
            return;
        }
        if (this.greaterContextDuple == null && this.scanner.isOnTopContext() && this.lastTokenOfDuple != null && this.firstTokenOfDuple != null) {
            if (tokenDuple.getStartOffset() > this.lastTokenOfDuple.getEndOffset()) {
                this.pastPointOfSelection = true;
                return;
            }
            int tokensFound = 0;
            IToken token = tokenDuple.getFirstToken();
            while (token != null) {
                if (token == this.firstTokenOfDuple) {
                    ++tokensFound;
                }
                if (token == this.lastTokenOfDuple) {
                    ++tokensFound;
                }
                if (token == tokenDuple.getLastToken()) break;
                token = token.getNext();
            }
            if (tokensFound == 2) {
                this.greaterContextDuple = tokenDuple;
                this.pastPointOfSelection = true;
            }
        }
    }

    protected void endDeclaration(IASTDeclaration declaration) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = declaration;
            throw new EndOfFileException();
        }
        super.endDeclaration(declaration);
    }

    protected void endExpression(IASTExpression expression) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = expression;
            throw new EndOfFileException();
        }
        super.endExpression(expression);
    }

    protected void endEnumerator(IASTEnumerator enumerator) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = enumerator;
            throw new EndOfFileException();
        }
        super.endEnumerator(enumerator);
    }

    protected void handleClassSpecifier(IASTClassSpecifier classSpecifier) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = classSpecifier;
            throw new EndOfFileException();
        }
        super.handleClassSpecifier(classSpecifier);
    }

    protected void handleEnumeration(IASTEnumerationSpecifier enumeration) throws EndOfFileException {
        if (this.tokenDupleCompleted()) {
            this.contextNode = enumeration;
            throw new EndOfFileException();
        }
        super.handleEnumeration(enumeration);
    }

    public static class SelectionParseResult
    implements IParser.ISelectionParseResult {
        private final String fileName;
        private final IASTOffsetableNamedElement node;

        public SelectionParseResult(IASTOffsetableNamedElement node, String fileName) {
            this.node = node;
            this.fileName = fileName;
        }

        public IASTOffsetableNamedElement getOffsetableNamedElement() {
            return this.node;
        }

        public String getFilename() {
            return this.fileName;
        }
    }
}

