/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.ContextException;
import org.eclipse.cdt.internal.core.parser.scanner.IScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextInclusion;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContextMacro;
import org.eclipse.cdt.internal.core.parser.util.TraceUtil;

public class ContextStack {
    private final IParserLogService log;
    private int current_size = 8;
    private int lastFileContext = 0;
    private IScannerContext[] cs = new IScannerContext[this.current_size];
    private int cs_pos = 0;
    private int currentInclusionArraySize = 16;
    private int currentInclusionIndex = 0;
    private String[] fileNames = new String[this.currentInclusionArraySize];
    private static final String EMPTY_STRING = "";
    private static IScannerContext sentinel = new SentinelContext();
    private IScanner scanner;

    public final String getInclusionFilename(int index) {
        try {
            return this.fileNames[index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return EMPTY_STRING;
        }
    }

    private final void addInclusionFilename(String filename) {
        try {
            this.fileNames[this.currentInclusionIndex++] = filename;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int newSize = this.currentInclusionArraySize * 2;
            String[] newFileNames = new String[newSize];
            System.arraycopy(this.fileNames, 0, newFileNames, 0, this.fileNames.length);
            newFileNames[this.currentInclusionArraySize++] = filename;
            this.currentInclusionArraySize = newSize;
            this.fileNames = newFileNames;
        }
    }

    public final void cs_push(IScannerContext c) {
        try {
            this.cs[this.cs_pos++] = c;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int new_size = this.current_size * 2;
            IScannerContext[] new_cs = new IScannerContext[new_size];
            System.arraycopy(this.cs, 0, new_cs, 0, this.cs.length);
            new_cs[this.current_size] = c;
            this.current_size = new_size;
            this.cs = new_cs;
        }
        this.scanner.setScannerContext(c);
    }

    public final IScannerContext cs_pop() {
        IScannerContext context = this.cs[--this.cs_pos];
        this.scanner.setScannerContext(this.cs_pos == 0 ? sentinel : this.cs[this.cs_pos - 1]);
        return context;
    }

    public ContextStack(IScanner scanner, IParserLogService l) {
        this.log = l;
        this.scanner = scanner;
        this.cs_push(sentinel);
        scanner.setScannerContext(sentinel);
    }

    public void updateInclusionContext(CodeReader code, IASTInclusion inclusion, ISourceElementRequestor requestor) throws ContextException {
        this.addInclusionFilename(new String(code.filename));
        ScannerContextInclusion context = new ScannerContextInclusion(code, inclusion, this.currentInclusionIndex - 1);
        if (this.isCircularInclusion(context.getContextName())) {
            throw new ContextException(0x200000B);
        }
        TraceUtil.outputTrace(this.log, "Scanner::ContextStack: entering inclusion ", null, context.getContextName(), null, null);
        context.getExtension().enterScope(requestor, null);
        this.cs_push(context);
        ++this.lastFileContext;
    }

    public void updateMacroContext(String reader, String filename, ISourceElementRequestor requestor, int macroOffset, int macroLength) throws ContextException {
        if (this.getCurrentContext().getKind() == IScannerContext.ContextKind.MACROEXPANSION) {
            macroOffset = ((ScannerContextMacro)this.getCurrentContext()).getOffset();
            macroLength = ((ScannerContextMacro)this.getCurrentContext()).getMacroLength();
        }
        this.cs_push(new ScannerContextMacro(reader, filename, macroOffset, macroLength));
    }

    protected void pushInitialContext(IScannerContext context) throws ContextException {
        this.addInclusionFilename(context.getContextName());
        ++this.lastFileContext;
        this.cs_push(context);
    }

    public boolean rollbackContext(ISourceElementRequestor requestor) {
        IScannerContext context = this.getCurrentContext();
        context.close();
        if (context.getKind() == IScannerContext.ContextKind.INCLUSION) {
            TraceUtil.outputTrace(this.log, "Scanner::ContextStack: ending inclusion ", null, context.getContextName(), null, null);
            ((ScannerContextInclusion)context).getExtension().exitScope(requestor, null);
            --this.lastFileContext;
        }
        this.cs_pop();
        return this.cs_pos != 0;
    }

    public void undoRollback(IScannerContext undoTo, ISourceElementRequestor requestor) {
        while (this.getCurrentContext() != undoTo) {
            IScannerContext context;
            if ((context = this.cs[this.cs_pos++]).getKind() == IScannerContext.ContextKind.INCLUSION) {
                ++this.lastFileContext;
            }
            this.scanner.setScannerContext(context);
        }
    }

    protected boolean shouldExpandDefinition(String symbol) {
        int i = this.cs_pos - 1;
        while (i >= 0) {
            if (this.cs[i].getKind() == IScannerContext.ContextKind.MACROEXPANSION && this.cs[i].getContextName().equals(symbol)) {
                return false;
            }
            --i;
        }
        return true;
    }

    protected boolean isCircularInclusion(String symbol) {
        int i = this.cs_pos - 1;
        while (i >= 0) {
            if (this.cs[i].getKind() == IScannerContext.ContextKind.INCLUSION && this.cs[i].getContextName().equals(symbol)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public final IScannerContext getCurrentContext() {
        return this.cs[this.cs_pos - 1];
    }

    public ScannerContextInclusion getMostRelevantFileContext() {
        if (this.cs[this.lastFileContext] != null && this.cs[this.lastFileContext] instanceof ScannerContextInclusion) {
            return (ScannerContextInclusion)this.cs[this.lastFileContext];
        }
        return null;
    }

    public int getMostRelevantFileContextIndex() {
        return this.getMostRelevantFileContext().getFilenameIndex();
    }

    public int getCurrentLineNumber() {
        ScannerContextInclusion mostRelevantFileContext = this.getMostRelevantFileContext();
        if (mostRelevantFileContext != null) {
            return mostRelevantFileContext.getLine();
        }
        return -1;
    }

    private static class SentinelContext
    implements IScannerContext {
        SentinelContext() {
        }

        public int getChar() {
            return 10;
        }

        public String getContextName() {
            return ContextStack.EMPTY_STRING;
        }

        public int getOffset() {
            return 0;
        }

        public void ungetChar(int undo) {
        }

        public boolean isFinal() {
            return false;
        }

        public int getKind() {
            return IScannerContext.ContextKind.SENTINEL;
        }

        public void close() {
        }
    }
}

