/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IDocument;
import org.eclipse.cdt.internal.core.index.IIndexer;
import org.eclipse.cdt.internal.core.index.IIndexerOutput;
import org.eclipse.cdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.core.resources.IFile;

public abstract class AbstractIndexer
implements IIndexer,
IIndexConstants,
ICSearchConstants {
    IIndexerOutput output;
    static final int CLASS = 1;
    static final int STRUCT = 2;
    static final int UNION = 3;
    static final int ENUM = 4;
    static final int VAR = 5;
    static final int TYPEDEF = 6;
    static final int DERIVED = 7;
    static final int FRIEND = 8;
    static final int FWD_CLASS = 9;
    static final int FWD_STRUCT = 10;
    static final int FWD_UNION = 11;
    public static boolean VERBOSE = false;
    private static final String C_SOURCE_ID = "org.eclipse.cdt.core.fileType.c_source";
    private static final String C_HEADER_ID = "org.eclipse.cdt.core.fileType.c_header";
    private static final String CPP_SOURCE_ID = "org.eclipse.cdt.core.fileType.cxx_source";
    private static final String CPP_HEADER_ID = "org.eclipse.cdt.core.fileType.cxx_header";

    public static void verbose(String log) {
        System.out.println("(" + Thread.currentThread() + ") " + log);
    }

    public void addClassSpecifier(IASTClassSpecifier classSpecification) {
        if (classSpecification.getClassKind().equals(ASTClassKind.CLASS)) {
            char[][] baseFullyQualifiedName;
            Iterator baseClauses = classSpecification.getBaseClauses();
            while (baseClauses.hasNext()) {
                IASTBaseSpecifier baseSpec = (IASTBaseSpecifier)baseClauses.next();
                try {
                    IASTTypeSpecifier typeSpec = baseSpec.getParentClassSpecifier();
                    if (!(typeSpec instanceof IASTClassSpecifier)) continue;
                    IASTClassSpecifier baseClassSpec = (IASTClassSpecifier)typeSpec;
                    baseFullyQualifiedName = baseClassSpec.getFullyQualifiedNameCharArrays();
                    this.output.addRef(AbstractIndexer.encodeTypeEntry(baseFullyQualifiedName, 7, ICSearchConstants.DECLARATIONS));
                }
                catch (ASTNotImplementedException aSTNotImplementedException) {}
            }
            Iterator friends = classSpecification.getFriends();
            while (friends.hasNext()) {
                IASTClassSpecifier friendClassSpec;
                Object decl = friends.next();
                if (decl instanceof IASTClassSpecifier) {
                    friendClassSpec = (IASTClassSpecifier)decl;
                    baseFullyQualifiedName = friendClassSpec.getFullyQualifiedNameCharArrays();
                    this.output.addRef(AbstractIndexer.encodeTypeEntry(baseFullyQualifiedName, 8, ICSearchConstants.DECLARATIONS));
                    continue;
                }
                if (decl instanceof IASTElaboratedTypeSpecifier) {
                    friendClassSpec = (IASTElaboratedTypeSpecifier)decl;
                    baseFullyQualifiedName = friendClassSpec.getFullyQualifiedNameCharArrays();
                    this.output.addRef(AbstractIndexer.encodeTypeEntry(baseFullyQualifiedName, 8, ICSearchConstants.DECLARATIONS));
                    continue;
                }
                if (decl instanceof IASTFunction) continue;
                boolean cfr_ignored_0 = decl instanceof IASTMethod;
            }
            this.output.addRef(AbstractIndexer.encodeTypeEntry(classSpecification.getFullyQualifiedNameCharArrays(), 1, ICSearchConstants.DECLARATIONS));
        } else if (classSpecification.getClassKind().equals(ASTClassKind.STRUCT)) {
            char[][] baseFullyQualifiedName;
            Iterator i = classSpecification.getBaseClauses();
            while (i.hasNext()) {
                IASTBaseSpecifier baseSpec = (IASTBaseSpecifier)i.next();
                try {
                    IASTTypeSpecifier typeSpec = baseSpec.getParentClassSpecifier();
                    if (!(typeSpec instanceof IASTClassSpecifier)) continue;
                    IASTClassSpecifier baseClassSpec = (IASTClassSpecifier)typeSpec;
                    baseFullyQualifiedName = baseClassSpec.getFullyQualifiedNameCharArrays();
                    this.output.addRef(AbstractIndexer.encodeTypeEntry(baseFullyQualifiedName, 7, ICSearchConstants.DECLARATIONS));
                }
                catch (ASTNotImplementedException aSTNotImplementedException) {}
            }
            Iterator friends = classSpecification.getFriends();
            while (friends.hasNext()) {
                IASTClassSpecifier friendClassSpec;
                Object decl = friends.next();
                if (decl instanceof IASTClassSpecifier) {
                    friendClassSpec = (IASTClassSpecifier)decl;
                    baseFullyQualifiedName = friendClassSpec.getFullyQualifiedNameCharArrays();
                    this.output.addRef(AbstractIndexer.encodeTypeEntry(baseFullyQualifiedName, 8, ICSearchConstants.DECLARATIONS));
                    continue;
                }
                if (decl instanceof IASTElaboratedTypeSpecifier) {
                    friendClassSpec = (IASTElaboratedTypeSpecifier)decl;
                    baseFullyQualifiedName = friendClassSpec.getFullyQualifiedNameCharArrays();
                    this.output.addRef(AbstractIndexer.encodeTypeEntry(baseFullyQualifiedName, 8, ICSearchConstants.DECLARATIONS));
                    continue;
                }
                if (decl instanceof IASTFunction) continue;
                boolean cfr_ignored_1 = decl instanceof IASTMethod;
            }
            this.output.addRef(AbstractIndexer.encodeTypeEntry(classSpecification.getFullyQualifiedNameCharArrays(), 2, ICSearchConstants.DECLARATIONS));
        } else if (classSpecification.getClassKind().equals(ASTClassKind.UNION)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(classSpecification.getFullyQualifiedNameCharArrays(), 3, ICSearchConstants.DECLARATIONS));
        }
    }

    public void addEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(enumeration.getFullyQualifiedNameCharArrays(), 4, ICSearchConstants.DECLARATIONS));
        Iterator i = enumeration.getEnumerators();
        while (i.hasNext()) {
            IASTEnumerator en = (IASTEnumerator)i.next();
            char[][] enumeratorFullName = this.createEnumeratorFullyQualifiedName(en);
            this.output.addRef(AbstractIndexer.encodeEntry(enumeratorFullName, IIndexConstants.ENUMTOR_DECL, 12));
        }
    }

    protected char[][] createEnumeratorFullyQualifiedName(IASTEnumerator en) {
        char[] name = en.getNameCharArray();
        IASTEnumerationSpecifier parent = en.getOwnerEnumerationSpecifier();
        char[][] parentName = parent.getFullyQualifiedNameCharArrays();
        char[][] enumeratorFullName = new char[parentName.length][];
        System.arraycopy(parentName, 0, enumeratorFullName, 0, parentName.length);
        enumeratorFullName[parentName.length - 1] = name;
        return enumeratorFullName;
    }

    public void addEnumeratorReference(IASTEnumerator enumerator) {
        this.output.addRef(AbstractIndexer.encodeEntry(this.createEnumeratorFullyQualifiedName(enumerator), IIndexConstants.ENUMTOR_REF, 11));
    }

    public void addMacro(IASTMacro macro) {
        char[][] macroName = new char[][]{macro.getNameCharArray()};
        this.output.addRef(AbstractIndexer.encodeEntry(macroName, IIndexConstants.MACRO_DECL, 10));
    }

    public void addEnumerationReference(IASTEnumerationSpecifier enumeration) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(enumeration.getFullyQualifiedNameCharArrays(), 4, ICSearchConstants.REFERENCES));
    }

    public void addVariable(IASTVariable variable) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(variable.getFullyQualifiedNameCharArrays(), 5, ICSearchConstants.DECLARATIONS));
    }

    public void addVariableReference(IASTVariable variable) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(variable.getFullyQualifiedNameCharArrays(), 5, ICSearchConstants.REFERENCES));
    }

    public void addParameterReference(IASTParameterDeclaration parameter) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(new char[][]{parameter.getNameCharArray()}, 5, ICSearchConstants.REFERENCES));
    }

    public void addTypedefDeclaration(IASTTypedefDeclaration typedef) {
        this.output.addRef(AbstractIndexer.encodeEntry(typedef.getFullyQualifiedNameCharArrays(), IIndexConstants.TYPEDEF_DECL, 11));
    }

    public void addFieldDeclaration(IASTField field) {
        this.output.addRef(AbstractIndexer.encodeEntry(field.getFullyQualifiedNameCharArrays(), IIndexConstants.FIELD_DECL, 10));
    }

    public void addFieldReference(IASTField field) {
        this.output.addRef(AbstractIndexer.encodeEntry(field.getFullyQualifiedNameCharArrays(), IIndexConstants.FIELD_REF, 9));
    }

    public void addMethodDeclaration(IASTMethod method) {
        this.output.addRef(AbstractIndexer.encodeEntry(method.getFullyQualifiedNameCharArrays(), IIndexConstants.METHOD_DECL, 11));
        Iterator i = method.getParameters();
        while (i.hasNext()) {
            Object parm = i.next();
            if (!(parm instanceof IASTParameterDeclaration)) continue;
            IASTParameterDeclaration parmDecl = (IASTParameterDeclaration)parm;
            this.output.addRef(AbstractIndexer.encodeTypeEntry(new char[][]{parmDecl.getNameCharArray()}, 5, ICSearchConstants.DECLARATIONS));
        }
    }

    public void addMethodReference(IASTMethod method) {
        this.output.addRef(AbstractIndexer.encodeEntry(method.getFullyQualifiedNameCharArrays(), IIndexConstants.METHOD_REF, 10));
    }

    public void addElaboratedForwardDeclaration(IASTElaboratedTypeSpecifier elaboratedType) {
        if (elaboratedType.getClassKind().equals(ASTClassKind.CLASS)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(elaboratedType.getFullyQualifiedNameCharArrays(), 9, ICSearchConstants.DECLARATIONS));
        } else if (elaboratedType.getClassKind().equals(ASTClassKind.STRUCT)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(elaboratedType.getFullyQualifiedNameCharArrays(), 10, ICSearchConstants.DECLARATIONS));
        } else if (elaboratedType.getClassKind().equals(ASTClassKind.UNION)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(elaboratedType.getFullyQualifiedNameCharArrays(), 11, ICSearchConstants.DECLARATIONS));
        }
    }

    public void addConstructorDeclaration() {
    }

    public void addConstructorReference() {
    }

    public void addMemberDeclaration() {
    }

    public void addMemberReference() {
    }

    public void addFunctionDeclaration(IASTFunction function) {
        this.output.addRef(AbstractIndexer.encodeEntry(function.getFullyQualifiedNameCharArrays(), IIndexConstants.FUNCTION_DECL, 13));
        Iterator i = function.getParameters();
        while (i.hasNext()) {
            Object parm = i.next();
            if (!(parm instanceof IASTParameterDeclaration)) continue;
            IASTParameterDeclaration parmDecl = (IASTParameterDeclaration)parm;
            this.output.addRef(AbstractIndexer.encodeTypeEntry(new char[][]{parmDecl.getNameCharArray()}, 5, ICSearchConstants.DECLARATIONS));
        }
    }

    public void addFunctionReference(IASTFunction function) {
        this.output.addRef(AbstractIndexer.encodeEntry(function.getFullyQualifiedNameCharArrays(), IIndexConstants.FUNCTION_REF, 12));
    }

    public void addNameReference() {
    }

    public void addNamespaceDefinition(IASTNamespaceDefinition namespace) {
        this.output.addRef(AbstractIndexer.encodeEntry(namespace.getFullyQualifiedNameCharArrays(), IIndexConstants.NAMESPACE_DECL, 14));
    }

    public void addNamespaceReference(IASTNamespaceDefinition namespace) {
        this.output.addRef(AbstractIndexer.encodeEntry(namespace.getFullyQualifiedNameCharArrays(), IIndexConstants.NAMESPACE_REF, 13));
    }

    public void addTypedefReference(IASTTypedefDeclaration typedef) {
        this.output.addRef(AbstractIndexer.encodeTypeEntry(typedef.getFullyQualifiedNameCharArrays(), 6, ICSearchConstants.REFERENCES));
    }

    private void addSuperTypeReference(int modifiers, char[] packageName, char[] typeName, char[][] enclosingTypeNames, char classOrInterface, char[] superTypeName, char superClassOrInterface) {
    }

    public void addTypeReference(char[] typeName) {
    }

    public void addClassReference(IASTTypeSpecifier reference) {
        char[][] fullyQualifiedName = null;
        Object classKind = null;
        if (reference instanceof IASTClassSpecifier) {
            IASTClassSpecifier classRef = (IASTClassSpecifier)reference;
            fullyQualifiedName = classRef.getFullyQualifiedNameCharArrays();
            classKind = classRef.getClassKind();
        } else if (reference instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier typeRef = (IASTElaboratedTypeSpecifier)reference;
            fullyQualifiedName = typeRef.getFullyQualifiedNameCharArrays();
            classKind = typeRef.getClassKind();
        }
        if (classKind.equals(ASTClassKind.CLASS)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(fullyQualifiedName, 1, ICSearchConstants.REFERENCES));
        } else if (classKind.equals(ASTClassKind.STRUCT)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(fullyQualifiedName, 2, ICSearchConstants.REFERENCES));
        } else if (classKind.equals(ASTClassKind.UNION)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(fullyQualifiedName, 3, ICSearchConstants.REFERENCES));
        }
    }

    public void addForwardClassReference(IASTTypeSpecifier reference) {
        char[][] fullyQualifiedName = null;
        Object classKind = null;
        if (reference instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier typeRef = (IASTElaboratedTypeSpecifier)reference;
            fullyQualifiedName = typeRef.getFullyQualifiedNameCharArrays();
            classKind = typeRef.getClassKind();
        }
        if (classKind == null) {
            return;
        }
        if (classKind.equals(ASTClassKind.CLASS)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(fullyQualifiedName, 9, ICSearchConstants.REFERENCES));
        } else if (classKind.equals(ASTClassKind.STRUCT)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(fullyQualifiedName, 10, ICSearchConstants.REFERENCES));
        } else if (classKind.equals(ASTClassKind.UNION)) {
            this.output.addRef(AbstractIndexer.encodeTypeEntry(fullyQualifiedName, 11, ICSearchConstants.REFERENCES));
        }
    }

    protected static final char[] encodeTypeEntry(char[][] fullTypeName, int typeType, ICSearchConstants.LimitTo encodeType) {
        int pos = 0;
        int nameLength = 0;
        int i = 0;
        while (i < fullTypeName.length) {
            char[] namePart = fullTypeName[i];
            nameLength += namePart.length;
            ++i;
        }
        char[] result = null;
        if (encodeType == ICSearchConstants.REFERENCES) {
            result = new char[8 + nameLength + fullTypeName.length + 1];
            pos = 8;
            System.arraycopy(IIndexConstants.TYPE_REF, 0, result, 0, 8);
        } else if (encodeType == ICSearchConstants.DECLARATIONS) {
            result = new char[9 + nameLength + fullTypeName.length + 1];
            pos = 9;
            System.arraycopy(IIndexConstants.TYPE_DECL, 0, result, 0, 9);
        }
        switch (typeType) {
            case 1: {
                result[pos++] = 67;
                break;
            }
            case 2: {
                result[pos++] = 83;
                break;
            }
            case 3: {
                result[pos++] = 85;
                break;
            }
            case 4: {
                result[pos++] = 69;
                break;
            }
            case 5: {
                result[pos++] = 86;
                break;
            }
            case 6: {
                result[pos++] = 84;
                break;
            }
            case 7: {
                result[pos++] = 68;
                break;
            }
            case 8: {
                result[pos++] = 70;
                break;
            }
            case 9: {
                result[pos++] = 71;
                break;
            }
            case 10: {
                result[pos++] = 72;
                break;
            }
            case 11: {
                result[pos++] = 73;
            }
        }
        result[pos++] = 47;
        if (fullTypeName.length > 0) {
            char[] tempName = fullTypeName[fullTypeName.length - 1];
            System.arraycopy(tempName, 0, result, pos, tempName.length);
            pos += tempName.length;
        }
        int i2 = fullTypeName.length - 2;
        while (i2 >= 0) {
            result[pos++] = 47;
            char[] tempName = fullTypeName[i2];
            System.arraycopy(tempName, 0, result, pos, tempName.length);
            pos += tempName.length;
            --i2;
        }
        if (VERBOSE) {
            AbstractIndexer.verbose(new String(result));
        }
        return result;
    }

    protected static final char[] encodeEntry(char[][] elementName, char[] prefix, int prefixSize) {
        int nameLength = 0;
        int i = 0;
        while (i < elementName.length) {
            char[] namePart = elementName[i];
            nameLength += namePart.length;
            ++i;
        }
        char[] result = new char[prefixSize + nameLength + elementName.length - 1];
        int pos = prefix.length;
        System.arraycopy(prefix, 0, result, 0, pos);
        if (elementName.length > 0) {
            char[] tempName = elementName[elementName.length - 1];
            System.arraycopy(tempName, 0, result, pos, tempName.length);
            pos += tempName.length;
        }
        int i2 = elementName.length - 2;
        while (i2 >= 0) {
            result[pos++] = 47;
            char[] tempName = elementName[i2];
            System.arraycopy(tempName, 0, result, pos, tempName.length);
            pos += tempName.length;
            --i2;
        }
        if (VERBOSE) {
            AbstractIndexer.verbose(new String(result));
        }
        return result;
    }

    public abstract IFile getResourceFile();

    public void index(IDocument document, IIndexerOutput output) throws IOException {
        this.output = output;
        if (this.shouldIndex(this.getResourceFile())) {
            this.indexFile(document);
        }
    }

    protected abstract void indexFile(IDocument var1) throws IOException;

    public boolean shouldIndex(IFile fileToBeIndexed) {
        String id;
        ICFileType type;
        return !(fileToBeIndexed == null || !(type = CCorePlugin.getDefault().getFileType(fileToBeIndexed.getProject(), fileToBeIndexed.getName())).isSource() && !type.isHeader() || !(id = type.getId()).equals(C_SOURCE_ID) && !id.equals(CPP_SOURCE_ID) && !id.equals(C_HEADER_ID) && !id.equals(CPP_HEADER_ID));
    }

    public static final char[] bestTypePrefix(ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limitTo, char[] typeName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == ICSearchConstants.DECLARATIONS) {
            prefix = IIndexConstants.TYPE_DECL;
        } else if (limitTo == ICSearchConstants.REFERENCES) {
            prefix = IIndexConstants.TYPE_REF;
        } else {
            return IIndexConstants.TYPE_ALL;
        }
        int classType = 0;
        if (searchFor == ICSearchConstants.CLASS) {
            classType = 67;
        } else if (searchFor == ICSearchConstants.STRUCT) {
            classType = 83;
        } else if (searchFor == ICSearchConstants.UNION) {
            classType = 85;
        } else if (searchFor == ICSearchConstants.ENUM) {
            classType = 69;
        } else if (searchFor == ICSearchConstants.TYPEDEF) {
            classType = 84;
        } else if (searchFor == ICSearchConstants.DERIVED) {
            classType = 68;
        } else if (searchFor == ICSearchConstants.FRIEND) {
            classType = 70;
        } else if (searchFor == ICSearchConstants.FWD_CLASS) {
            classType = 71;
        } else if (searchFor == ICSearchConstants.FWD_STRUCT) {
            classType = 72;
        } else if (searchFor == ICSearchConstants.FWD_UNION) {
            classType = 73;
        } else {
            return prefix;
        }
        return AbstractIndexer.bestPrefix(prefix, (char)classType, typeName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestNamespacePrefix(ICSearchConstants.LimitTo limitTo, char[] namespaceName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            prefix = IIndexConstants.NAMESPACE_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            prefix = IIndexConstants.NAMESPACE_DECL;
        } else {
            return IIndexConstants.NAMESPACE_ALL;
        }
        return AbstractIndexer.bestPrefix(prefix, '\u0000', namespaceName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestVariablePrefix(ICSearchConstants.LimitTo limitTo, char[] varName, char[][] containingTypes, int matchMode, boolean isCaseSenstive) {
        char[] prefix = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            prefix = IIndexConstants.TYPE_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            prefix = IIndexConstants.TYPE_DECL;
        } else {
            return IIndexConstants.TYPE_ALL;
        }
        return AbstractIndexer.bestPrefix(prefix, 'V', varName, containingTypes, matchMode, isCaseSenstive);
    }

    public static final char[] bestFieldPrefix(ICSearchConstants.LimitTo limitTo, char[] fieldName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            prefix = IIndexConstants.FIELD_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            prefix = IIndexConstants.FIELD_DECL;
        } else {
            return IIndexConstants.FIELD_ALL;
        }
        return AbstractIndexer.bestPrefix(prefix, '\u0000', fieldName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestEnumeratorPrefix(ICSearchConstants.LimitTo limitTo, char[] enumeratorName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            prefix = IIndexConstants.ENUMTOR_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            prefix = IIndexConstants.ENUMTOR_DECL;
        } else {
            if (limitTo == ICSearchConstants.ALL_OCCURRENCES) {
                return IIndexConstants.ENUMTOR_ALL;
            }
            return "noEnumtorDefs".toCharArray();
        }
        return AbstractIndexer.bestPrefix(prefix, '\u0000', enumeratorName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestMethodPrefix(ICSearchConstants.LimitTo limitTo, char[] methodName, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            prefix = IIndexConstants.METHOD_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            prefix = IIndexConstants.METHOD_DECL;
        } else {
            if (limitTo == ICSearchConstants.DEFINITIONS) {
                return IIndexConstants.METHOD_ALL;
            }
            return IIndexConstants.METHOD_ALL;
        }
        return AbstractIndexer.bestPrefix(prefix, '\u0000', methodName, containingTypes, matchMode, isCaseSensitive);
    }

    public static final char[] bestFunctionPrefix(ICSearchConstants.LimitTo limitTo, char[] functionName, int matchMode, boolean isCaseSensitive) {
        char[] prefix = null;
        if (limitTo == ICSearchConstants.REFERENCES) {
            prefix = IIndexConstants.FUNCTION_REF;
        } else if (limitTo == ICSearchConstants.DECLARATIONS) {
            prefix = IIndexConstants.FUNCTION_DECL;
        } else {
            if (limitTo == ICSearchConstants.DEFINITIONS) {
                return IIndexConstants.FUNCTION_ALL;
            }
            return IIndexConstants.FUNCTION_ALL;
        }
        return AbstractIndexer.bestPrefix(prefix, '\u0000', functionName, null, matchMode, isCaseSensitive);
    }

    public static final char[] bestPrefix(char[] prefix, char optionalType, char[] name, char[][] containingTypes, int matchMode, boolean isCaseSensitive) {
        int wildPos;
        int questionPos;
        char[] temp;
        int length;
        int starPos;
        int pos;
        char[] result;
        block22: {
            block21: {
                result = null;
                pos = 0;
                starPos = -1;
                length = prefix.length;
                if (optionalType != '\u0000') {
                    length += 2;
                }
                if (isCaseSensitive) break block21;
                name = null;
                break block22;
            }
            if (matchMode != 2 || name == null) break block22;
            temp = new char[name.length];
            boolean isEscaped = false;
            int tmpIdx = 0;
            int i = 0;
            while (i < name.length) {
                block25: {
                    block26: {
                        block23: {
                            block24: {
                                if (name[i] != '\\') break block23;
                                if (isEscaped) break block24;
                                isEscaped = true;
                                break block25;
                            }
                            isEscaped = false;
                            break block26;
                        }
                        if (name[i] == '*' && !isEscaped) {
                            starPos = i;
                            break;
                        }
                    }
                    temp[tmpIdx++] = name[i];
                }
                ++i;
            }
            name = new char[tmpIdx];
            System.arraycopy(temp, 0, name, 0, tmpIdx);
            questionPos = CharOperation.indexOf('?', name);
            wildPos = starPos >= 0 ? (questionPos >= 0 ? (starPos < questionPos ? starPos : questionPos) : starPos) : questionPos;
            switch (wildPos) {
                case -1: {
                    break;
                }
                case 0: {
                    name = null;
                    break;
                }
                default: {
                    name = CharOperation.subarray(name, 0, wildPos);
                }
            }
        }
        if (name != null) {
            length += name.length;
        } else {
            result = new char[length];
            pos = prefix.length;
            System.arraycopy(prefix, 0, result, 0, pos);
            if (optionalType != '\u0000') {
                result[pos++] = optionalType;
                result[pos++] = 47;
            }
            return result;
        }
        if (containingTypes != null) {
            int i = 0;
            while (i < containingTypes.length) {
                if (containingTypes[i].length > 0) {
                    length += containingTypes[i].length;
                    ++length;
                }
                ++i;
            }
        }
        temp = new char[length];
        pos = prefix.length;
        System.arraycopy(prefix, 0, temp, 0, pos);
        if (optionalType != '\u0000') {
            temp[pos++] = optionalType;
            temp[pos++] = 47;
        }
        System.arraycopy(name, 0, temp, pos, name.length);
        pos += name.length;
        if (containingTypes != null) {
            int i = containingTypes.length - 1;
            while (i >= 0) {
                if (matchMode == 2) {
                    starPos = CharOperation.indexOf('*', containingTypes[i]);
                    questionPos = CharOperation.indexOf('?', containingTypes[i]);
                    wildPos = starPos >= 0 ? (questionPos >= 0 ? (starPos < questionPos ? starPos : questionPos) : starPos) : questionPos;
                    if (wildPos >= 0) {
                        temp[pos++] = 47;
                        System.arraycopy(containingTypes[i], 0, temp, pos, wildPos);
                        pos += starPos;
                        break;
                    }
                }
                if (containingTypes[i].length > 0) {
                    temp[pos++] = 47;
                    System.arraycopy(containingTypes[i], 0, temp, pos, containingTypes[i].length);
                    pos += containingTypes[i].length;
                }
                --i;
            }
        }
        if (pos < length) {
            result = new char[pos];
            System.arraycopy(temp, 0, result, 0, pos);
        } else {
            result = temp;
        }
        return result;
    }

    public static final char[] bestMacroPrefix(ICSearchConstants.LimitTo limitTo, char[] macroName, int matchMode, boolean isCaseSenstive) {
        char[] prefix = null;
        if (limitTo != ICSearchConstants.DECLARATIONS) {
            return null;
        }
        prefix = IIndexConstants.MACRO_DECL;
        return AbstractIndexer.bestPrefix(prefix, '\u0000', macroName, null, matchMode, isCaseSenstive);
    }

    public static final char[] bestIncludePrefix(ICSearchConstants.LimitTo limitTo, char[] incName, int matchMode, boolean isCaseSenstive) {
        char[] prefix = null;
        if (limitTo != ICSearchConstants.REFERENCES) {
            return null;
        }
        prefix = IIndexConstants.INCLUDE_REF;
        return AbstractIndexer.bestPrefix(prefix, '\u0000', incName, null, matchMode, isCaseSenstive);
    }

    public void addInclude(IASTInclusion inclusion, IASTInclusion parent) {
        this.output.addIncludeRef(inclusion.getFullFileName());
        this.output.addRelatives(inclusion.getFullFileName(), parent != null ? parent.getFullFileName() : null);
        char[][] incName = new char[][]{inclusion.getFullFileName().toCharArray()};
        this.output.addRef(AbstractIndexer.encodeEntry(incName, IIndexConstants.INCLUDE_REF, 11));
    }
}

