/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class MakefilePartitionScanner
extends RuleBasedPartitionScanner {
    public static final String MAKEFILE_COMMENT = "makefile_comment";
    public static final String MAKEFILE_MACRO_ASSIGNEMENT = "makefile_macro_assignement";
    public static final String MAKEFILE_INCLUDE_BLOCK = "makefile_include_block";
    public static final String MAKEFILE_IF_BLOCK = "makefile_if_block";
    public static final String MAKEFILE_DEF_BLOCK = "makefile_def_block";
    public static final String MAKEFILE_OTHER = "makefile_other";
    public static final String[] TYPES = new String[]{"makefile_comment", "makefile_macro_assignement", "makefile_include_block", "makefile_if_block", "makefile_def_block", "makefile_other"};
    private char[][] fModDelimiters = new char[][]{{'\r', '\n'}, {'\r'}, {'\n'}};

    public MakefilePartitionScanner() {
        Token tComment = new Token((Object)MAKEFILE_COMMENT);
        Token tMacro = new Token((Object)MAKEFILE_MACRO_ASSIGNEMENT);
        Token tInclude = new Token((Object)MAKEFILE_INCLUDE_BLOCK);
        Token tIf = new Token((Object)MAKEFILE_IF_BLOCK);
        Token tDef = new Token((Object)MAKEFILE_DEF_BLOCK);
        Token tOther = new Token((Object)MAKEFILE_OTHER);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("#", (IToken)tComment, '\\'));
        rules.add(new EndOfLineRule("include", (IToken)tInclude));
        rules.add(new EndOfLineRule("export", (IToken)tDef));
        rules.add(new EndOfLineRule("unexport", (IToken)tDef));
        rules.add(new EndOfLineRule("vpath", (IToken)tDef));
        rules.add(new EndOfLineRule("override", (IToken)tDef));
        rules.add(new MultiLineRule("define", "endef", (IToken)tDef));
        rules.add(new MultiLineRule("override define", "endef", (IToken)tDef));
        rules.add(new MultiLineRule("ifdef", "endif", (IToken)tIf));
        rules.add(new MultiLineRule("ifndef", "endif", (IToken)tIf));
        rules.add(new MultiLineRule("ifeq", "endif", (IToken)tIf));
        rules.add(new MultiLineRule("ifnneq", "endif", (IToken)tIf));
        rules.add(new MacroRule((IToken)tMacro, (IToken)tOther));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    public char[][] getLegalLineDelimiters() {
        return this.fModDelimiters;
    }

    private class MacroRule
    implements IPredicateRule {
        private static final int INIT_STATE = 0;
        private static final int VAR_STATE = 1;
        private static final int END_VAR_STATE = 2;
        private static final int EQUAL_STATE = 3;
        private static final int FINISH_STATE = 4;
        private static final int ERROR_STATE = 5;
        private IToken token;
        private StringBuffer buffer = new StringBuffer();
        protected IToken defaultToken;

        public MacroRule(IToken token, IToken defaultToken) {
            this.token = token;
            this.defaultToken = defaultToken;
        }

        public IToken getSuccessToken() {
            return this.token;
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            this.buffer.setLength(0);
            int state = 0;
            if (resume) {
                this.scanToBeginOfLine(scanner);
            }
            int c = scanner.read();
            while (c != -1) {
                switch (state) {
                    case 0: {
                        if (c != 10 && Character.isWhitespace((char)c)) break;
                        if (this.isValidCharacter(c)) {
                            state = 1;
                            break;
                        }
                        state = 5;
                        break;
                    }
                    case 1: {
                        if (this.isValidCharacter(c)) break;
                    }
                    case 2: {
                        if (c != 10 && Character.isWhitespace((char)c)) {
                            state = 2;
                            break;
                        }
                        if (c == 58 || c == 43) {
                            state = 3;
                            break;
                        }
                        if (c == 61) {
                            state = 4;
                            break;
                        }
                        if (state == 2) {
                            scanner.unread();
                        }
                        state = 5;
                        break;
                    }
                    case 3: {
                        if (c == 61) {
                            state = 4;
                            break;
                        }
                        state = 5;
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                if (state >= 4) break;
                this.buffer.append((char)c);
                c = scanner.read();
            }
            scanner.unread();
            if (state == 4) {
                this.scanToEndOfLine(scanner);
                return this.token;
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return Token.UNDEFINED;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            return this.evaluate(scanner, false);
        }

        protected void unreadBuffer(ICharacterScanner scanner) {
            int i = this.buffer.length() - 1;
            while (i >= 0) {
                scanner.unread();
                --i;
            }
        }

        private void scanToEndOfLine(ICharacterScanner scanner) {
            int c;
            char[][] delimiters = scanner.getLegalLineDelimiters();
            while ((c = scanner.read()) != -1) {
                int i = 0;
                while (i < delimiters.length) {
                    if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i])) {
                        return;
                    }
                    ++i;
                }
            }
        }

        private void scanToBeginOfLine(ICharacterScanner scanner) {
            while (scanner.getColumn() != 0) {
                scanner.unread();
            }
        }

        private boolean sequenceDetected(ICharacterScanner scanner, char[] sequence) {
            int i = 1;
            while (i < sequence.length) {
                int c = scanner.read();
                if (c == -1) {
                    return true;
                }
                if (c != sequence[i]) {
                    while (i > 0) {
                        scanner.unread();
                        --i;
                    }
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected boolean isValidCharacter(int c) {
            char c0 = (char)c;
            return Character.isLetterOrDigit(c0) || c0 == '_';
        }
    }
}

