/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.views;

import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.make.ui.MakeContentProvider;
import org.eclipse.cdt.make.ui.MakeLabelProvider;
import org.eclipse.cdt.make.ui.views.AddTargetAction;
import org.eclipse.cdt.make.ui.views.BuildTargetAction;
import org.eclipse.cdt.make.ui.views.DeleteTargetAction;
import org.eclipse.cdt.make.ui.views.EditTargetAction;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class MakeView
extends ViewPart {
    private BuildTargetAction buildTargetAction;
    private EditTargetAction editTargetAction;
    private DeleteTargetAction deleteTargetAction;
    AddTargetAction addTargetAction;
    TreeViewer viewer;
    DrillDownAdapter drillDownAdapter;

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void createPartControl(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)IMakeHelpContextIds.MAKE_VIEW);
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MakeView.this.handleDoubleClick(event);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MakeView.this.handleSelectionChanged(event);
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    MakeView.this.handleDeleteKeyPressed();
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new MakeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MakeLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void makeActions() {
        this.buildTargetAction = new BuildTargetAction(this.viewer.getControl().getShell());
        this.addTargetAction = new AddTargetAction(this.viewer.getControl().getShell());
        this.deleteTargetAction = new DeleteTargetAction(this.viewer.getControl().getShell());
        this.editTargetAction = new EditTargetAction(this.viewer.getControl().getShell());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager toolBar) {
        this.drillDownAdapter.addNavigationActions(toolBar);
        toolBar.add((IAction)this.buildTargetAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MakeView.this.fillContextMenu(manager);
                MakeView.this.updateActions((IStructuredSelection)MakeView.this.viewer.getSelection());
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.buildTargetAction);
        manager.add((IAction)this.addTargetAction);
        manager.add((IAction)this.deleteTargetAction);
        manager.add((IAction)this.editTargetAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    protected void handleDeleteKeyPressed() {
        this.deleteTargetAction.run();
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        this.buildTargetAction.run();
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateActions(sel);
    }

    void updateActions(IStructuredSelection sel) {
        this.addTargetAction.selectionChanged(sel);
        this.buildTargetAction.selectionChanged(sel);
        this.deleteTargetAction.selectionChanged(sel);
        this.editTargetAction.selectionChanged(sel);
    }
}

