/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.search.SimpleLookupTable;
import org.eclipse.cdt.internal.core.search.indexing.AddFolderToIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexAllProject
extends IndexRequest {
    IProject project;

    public IndexAllProject(IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.project = project;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexAllProject) {
            return this.project.equals((Object)((IndexAllProject)o).project);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        ReadWriteMonitor monitor;
        block19: {
            block18: {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                if (!this.project.isAccessible()) {
                    return true;
                }
                IIndex index = this.manager.getIndex(this.indexPath, true, true);
                if (index == null) {
                    return true;
                }
                monitor = this.manager.getMonitorFor(index);
                if (monitor == null) {
                    return true;
                }
                try {
                    try {
                        CModel model;
                        monitor.enterRead();
                        this.saveIfNecessary(index, monitor);
                        IQueryResult[] results = index.queryInDocumentNames("");
                        int max = results == null ? 0 : results.length;
                        SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                        int i = 0;
                        while (true) {
                            if (i >= max) {
                                model = CModelManager.getDefault().getCModel();
                                if (model != null) break;
                                Object var12_11 = null;
                                monitor.exitRead();
                                return false;
                            }
                            indexedFileNames.put(results[i].getPath(), "DELETED");
                            ++i;
                        }
                        ICProject cProject = model.getCProject(this.project.getName());
                        if (cProject == null) {
                            break block18;
                        }
                        ISourceRoot[] sourceRoot = cProject.getSourceRoots();
                        int i2 = 0;
                        while (true) {
                            if (i2 >= sourceRoot.length) {
                                this.manager.request(new SaveIndex(this.indexPath, this.manager));
                                break block19;
                            }
                            if (sourceRoot[i2] instanceof SourceRoot) {
                                ISourceEntry tempEntry = ((SourceRoot)sourceRoot[i2]).getSourceEntry();
                                this.manager.request(new AddFolderToIndex(sourceRoot[i2].getPath(), this.project, tempEntry.fullExclusionPatternChars(), this.manager));
                            }
                            ++i2;
                        }
                    }
                    catch (CoreException e) {
                        if (IndexManager.VERBOSE) {
                            JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                            e.printStackTrace();
                        }
                        this.manager.removeIndex(this.indexPath);
                        Object var12_13 = null;
                        monitor.exitRead();
                        return false;
                    }
                    catch (IOException e) {
                        if (IndexManager.VERBOSE) {
                            JobManager.verbose("-> failed to index " + this.project + " because of the following exception:");
                            e.printStackTrace();
                        }
                        this.manager.removeIndex(this.indexPath);
                        Object var12_14 = null;
                        monitor.exitRead();
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    monitor.exitRead();
                    throw throwable;
                }
            }
            Object var12_12 = null;
            monitor.exitRead();
            return false;
        }
        Object var12_16 = null;
        monitor.exitRead();
        return true;
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing project " + this.project.getFullPath();
    }
}

