/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import org.eclipse.core.runtime.IProgressMonitor;

public class TimeOut
implements Runnable {
    protected Thread thread;
    protected boolean enabled;
    protected IProgressMonitor pm = null;
    private int timeout = 0;
    private int threadPriority = 2;
    boolean debug = false;
    private String threadName = null;
    boolean readyToRun = true;

    public TimeOut() {
        this.reset();
    }

    public TimeOut(String threadName) {
        this.threadName = threadName;
        this.reset();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.thread != null) {
            try {
                TimeOut timeOut = this;
                synchronized (timeOut) {
                    if (this.enabled) {
                        this.readyToRun = false;
                        this.wait(this.timeout);
                        if (this.enabled) {
                            if (this.pm != null) {
                                this.pm.setCanceled(true);
                            }
                            this.enabled = false;
                        }
                    } else {
                        while (!this.enabled) {
                            this.readyToRun = true;
                            this.wait();
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void startTimer() {
        this.enabled = true;
        this.notify();
    }

    public synchronized void stopTimer() {
        this.enabled = false;
        this.notify();
    }

    public void reset() {
        this.enabled = false;
        this.thread = this.threadName != null ? new Thread((Runnable)this, this.threadName) : new Thread((Runnable)this, "Time Out Thread");
        this.thread.setDaemon(true);
        this.thread.setPriority(this.threadPriority);
        this.thread.start();
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.pm;
    }

    public void setProgressMonitor(IProgressMonitor pm) {
        this.pm = pm;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isReadyToRun() {
        return this.readyToRun;
    }
}

