/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class CPathProjectsEntryPage
extends CPathBasePage {
    private CheckedListDialogField fProjectsList;
    ICProject fCurrCProject;
    private ListDialogField fCPathList;

    public CPathProjectsEntryPage(ListDialogField cPathList) {
        super(CPathEntryMessages.getString("ProjectsEntryPage.title"));
        this.setDescription(CPathEntryMessages.getString("ProjectsEntryPage.description"));
        ProjectsListListener listener = new ProjectsListListener();
        String[] buttonLabels = new String[]{CPathEntryMessages.getString("ProjectsEntryPage.projects.checkall.button"), CPathEntryMessages.getString("ProjectsEntryWorkbookPage.projects.uncheckall.button")};
        this.fProjectsList = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new CPElementLabelProvider());
        this.fProjectsList.setDialogFieldListener(listener);
        this.fProjectsList.setLabelText(CPathEntryMessages.getString("ProjectsEntryPage.projects.label"));
        this.fProjectsList.setCheckAllButtonIndex(0);
        this.fProjectsList.setUncheckAllButtonIndex(1);
        this.fProjectsList.setViewerSorter(new CPElementSorter());
        this.fCPathList = cPathList;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
    }

    public void performDefaults() {
    }

    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fProjectsList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getListControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(buttonBarWidth);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.std_prop_projects");
    }

    public void init(ICProject cproject) {
        this.updateProjectsList(cproject);
    }

    void updateProjectsList(ICProject currCProject) {
        ICModel cmodel = currCProject.getCModel();
        ArrayList<CPElement> projects = new ArrayList<CPElement>();
        ArrayList<CPElement> checkedProjects = new ArrayList<CPElement>();
        try {
            ICProject[] cprojects = cmodel.getCProjects();
            ArrayList<Object> existingProjects = new ArrayList<Object>(cprojects.length);
            existingProjects.add(currCProject.getProject());
            List cpelements = this.fCPathList.getElements();
            int i = cpelements.size() - 1;
            while (i >= 0) {
                CPElement cpelem = (CPElement)cpelements.get(i);
                if (this.isEntryKind(cpelem.getEntryKind())) {
                    existingProjects.add(cpelem.getResource());
                    projects.add(cpelem);
                    checkedProjects.add(cpelem);
                }
                --i;
            }
            i = 0;
            while (i < cprojects.length) {
                IProject proj = cprojects[i].getProject();
                if (!existingProjects.contains(proj)) {
                    projects.add(new CPElement(this.fCurrCProject, 2, proj.getFullPath(), (IResource)proj));
                }
                ++i;
            }
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e);
        }
        this.fProjectsList.setElements(projects);
        this.fProjectsList.setCheckedElements(checkedProjects);
        this.fCurrCProject = currCProject;
    }

    void updateCPathList() {
        List projelements = this.fProjectsList.getCheckedElements();
        boolean remove = false;
        List pelements = this.fCPathList.getElements();
        int i = pelements.size() - 1;
        while (i >= 0) {
            CPElement pe = (CPElement)pelements.get(i);
            if (this.isEntryKind(pe.getEntryKind()) && !projelements.remove(pe)) {
                pelements.remove(i);
                remove = true;
            }
            --i;
        }
        i = 0;
        while (i < projelements.size()) {
            pelements.add(projelements.get(i));
            ++i;
        }
        if (remove || projelements.size() > 0) {
            this.fCPathList.setElements(pelements);
        }
    }

    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    public boolean isEntryKind(int kind) {
        return kind == 2;
    }

    private class ProjectsListListener
    implements IDialogFieldListener {
        ProjectsListListener() {
        }

        public void dialogFieldChanged(DialogField field) {
            if (CPathProjectsEntryPage.this.fCurrCProject != null) {
                CPathProjectsEntryPage.this.updateCPathList();
            }
        }
    }
}

