/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.SymbolIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTBaseSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ReferenceCache;
import org.eclipse.cdt.internal.core.parser.ast.complete.UnresolvedReferenceDuple;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTClassSpecifier
extends ASTScope
implements IASTClassSpecifier {
    private List declarations = null;
    private final IASTClassSpecifier.ClassNameType classNameType;
    private final ASTClassKind classKind;
    private ASTAccessVisibility currentVisibility;
    private final ASTQualifiedNamedElement qualifiedName;
    private List references;
    private List unresolvedCrossReferences = Collections.EMPTY_LIST;
    private boolean processingUnresolvedReferences = false;
    private List resolvedCrossReferences = Collections.EMPTY_LIST;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;
    private final char[] fn;

    public ASTClassSpecifier(ISymbol symbol, ASTClassKind kind, IASTClassSpecifier.ClassNameType type, ASTAccessVisibility access, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, List references, char[] filename) {
        super(symbol);
        this.classKind = kind;
        this.classNameType = type;
        this.currentVisibility = access;
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), symbol.getName());
        this.references = references;
        this.fn = filename;
    }

    public IASTClassSpecifier.ClassNameType getClassNameType() {
        return this.classNameType;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public Iterator getBaseClauses() {
        return new BaseIterator((IDerivableContainerSymbol)this.getSymbol());
    }

    private List getBaseClausesList() {
        List clauses = ((IDerivableContainerSymbol)this.getSymbol()).getParents();
        return clauses != null ? clauses : Collections.EMPTY_LIST;
    }

    public ASTAccessVisibility getCurrentVisibilityMode() {
        return this.currentVisibility;
    }

    public void setCurrentVisibility(ASTAccessVisibility visibility) {
        this.currentVisibility = visibility;
    }

    public String getName() {
        return String.valueOf(this.symbol.getName());
    }

    public char[] getNameCharArray() {
        return this.symbol.getName();
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        manager.processReferences(this.references, requestor);
        this.references = null;
        try {
            requestor.enterClassSpecifier(this);
        }
        catch (Exception exception) {}
        List bases = this.getBaseClausesList();
        int size = bases.size();
        int i = 0;
        while (i < size) {
            IDerivableContainerSymbol.IParentSymbol pw = (IDerivableContainerSymbol.IParentSymbol)bases.get(i);
            ASTBaseSpecifier baseSpec = new ASTBaseSpecifier(pw.getParent(), pw.isVirtual(), pw.getAccess(), pw.getOffset(), pw.getReferences());
            baseSpec.acceptElement(requestor, manager);
            ++i;
        }
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        manager.processReferences(this.resolvedCrossReferences, requestor);
        try {
            requestor.exitClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.symbol.getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public Iterator getDeclarations() {
        if (this.declarations != null) {
            return this.declarations.iterator();
        }
        return super.getDeclarations();
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public void initDeclarations() {
        this.declarations = new ArrayList(0);
    }

    public void addUnresolvedReference(UnresolvedReferenceDuple duple) {
        if (!this.processingUnresolvedReferences) {
            if (this.unresolvedCrossReferences == Collections.EMPTY_LIST) {
                this.unresolvedCrossReferences = new ArrayList();
            }
            this.unresolvedCrossReferences.add(duple);
        }
    }

    public List getUnresolvedReferences() {
        return this.unresolvedCrossReferences;
    }

    public void setProcessingUnresolvedReferences(boolean processing) {
        this.processingUnresolvedReferences = processing;
    }

    public void setExtraReferences(List references, ReferenceCache cache) {
        if (references != null && !references.isEmpty()) {
            int i = 0;
            while (i < references.size()) {
                IASTReference r = (IASTReference)references.get(i);
                if (this.resolvedCrossReferences == Collections.EMPTY_LIST) {
                    this.resolvedCrossReferences = new ArrayList(references.size());
                }
                this.resolvedCrossReferences.add(r);
                ++i;
            }
        }
    }

    public Iterator getFriends() {
        IDerivableContainerSymbol s = (IDerivableContainerSymbol)this.getSymbol();
        return new SymbolIterator(s.getFriends().iterator());
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getFilename() {
        return this.fn;
    }

    public class BaseIterator
    implements Iterator {
        private final Iterator parents;

        public BaseIterator(IDerivableContainerSymbol symbol) {
            this.parents = symbol.getParents() != null ? symbol.getParents().iterator() : null;
        }

        public boolean hasNext() {
            if (this.parents == null) {
                return false;
            }
            return this.parents.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IDerivableContainerSymbol.IParentSymbol pw = (IDerivableContainerSymbol.IParentSymbol)this.parents.next();
            return new ASTBaseSpecifier(pw.getParent(), pw.isVirtual(), pw.getAccess(), pw.getOffset(), pw.getReferences());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

