/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTIdExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.ast.complete.ExpressionResult;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public abstract class ASTExpression
extends ASTNode
implements IASTExpression {
    private final IASTExpression.Kind kind;
    private List references;
    private ExpressionResult resultType;
    private static final String EMPTY_STRING = "";
    private static final char[] EMPTY_CHAR_ARRAY = "".toCharArray();

    public ASTExpression(IASTExpression.Kind kind, List references) {
        this.kind = kind;
        this.references = references;
    }

    public IASTExpression.Kind getExpressionKind() {
        return this.kind;
    }

    public long evaluateExpression() throws ASTExpressionEvaluationException {
        throw new ASTExpressionEvaluationException();
    }

    public List getReferences() {
        return this.references;
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            this.reconcileReferences(manager);
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
        manager.processReferences(this.references, requestor);
        this.references = null;
        this.processCallbacks(requestor, manager);
        try {
            this.purgeReferences();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
    }

    protected void processCallbacks(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public ExpressionResult getResultType() {
        return this.resultType;
    }

    public void setResultType(ExpressionResult i) {
        this.resultType = i;
    }

    public void reconcileReferences(IReferenceManager manager) throws ASTNotImplementedException {
    }

    protected void reconcileSubExpression(ASTExpression subExpression, IReferenceManager manager) {
        if (subExpression != null && subExpression.getReferences() != null) {
            List refs = subExpression.getReferences();
            int size = refs.size();
            int i = 0;
            while (i < size) {
                IASTReference aReference = (IASTReference)refs.get(i);
                if (aReference != null && this.references.contains(aReference)) {
                    refs.remove(i--);
                    --size;
                    manager.returnReference(aReference);
                }
                ++i;
            }
        }
    }

    public void purgeReferences() throws ASTNotImplementedException {
    }

    protected void purgeSubExpression(ASTExpression subExpression) {
        if (subExpression != null && subExpression.getReferences() != null) {
            subExpression.getReferences().clear();
        }
    }

    protected String getStringPrefix() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ASTExpression w/Kind=");
        buffer.append(this.kind.getKindName());
        return buffer.toString();
    }

    public IContainerSymbol getLookupQualificationSymbol() throws IASTNode.LookupError {
        ExpressionResult result = this.getResultType();
        ITypeInfo type = result != null ? result.getResult() : null;
        IContainerSymbol containerSymbol = null;
        if (type != null && type.getTypeSymbol() != null) {
            TypeInfoProvider provider = type.getTypeSymbol().getSymbolTable().getTypeInfoProvider();
            if ((type = type.getFinalType(provider)).isType(ITypeInfo.t_type) && type.getTypeSymbol() != null && type.getTypeSymbol() instanceof IContainerSymbol) {
                containerSymbol = (IContainerSymbol)type.getTypeSymbol();
            }
            provider.returnTypeInfo(type);
        }
        return containerSymbol;
    }

    public boolean shouldFilterLookupResult(ISymbol symbol) {
        ITypeInfo type;
        ExpressionResult result = this.getResultType();
        ITypeInfo iTypeInfo = type = result != null ? result.getResult() : null;
        if (type != null) {
            boolean answer = false;
            TypeInfoProvider provider = symbol.getSymbolTable().getTypeInfoProvider();
            if ((type = type.getFinalType(provider)).checkBit(1024) && !symbol.getTypeInfo().checkBit(1024)) {
                answer = true;
            }
            if (type.checkBit(2048) && !symbol.getTypeInfo().checkBit(2048)) {
                answer = true;
            }
            provider.returnTypeInfo(type);
            return answer;
        }
        return false;
    }

    public ASTExpression findOwnerExpressionForIDExpression(ITokenDuple duple) {
        return null;
    }

    protected ASTExpression recursiveFindExpressionForDuple(IASTExpression expression, ITokenDuple duple) {
        if (expression == null) {
            return null;
        }
        return ((ASTExpression)expression).findOwnerExpressionForIDExpression(duple);
    }

    protected boolean isIDExpressionForDuple(IASTExpression expression, ITokenDuple duple) {
        if (expression == null) {
            return false;
        }
        if (expression.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION && expression instanceof ASTIdExpression) {
            ITokenDuple expressionDuple = ((ASTIdExpression)expression).getIdExpressionTokenDuple();
            if (expressionDuple.equals(duple)) {
                return true;
            }
            if (expressionDuple.contains(duple)) {
                return true;
            }
        }
        return false;
    }

    public IASTExpression getLHSExpression() {
        return null;
    }

    public IASTExpression getRHSExpression() {
        return null;
    }

    public IASTExpression getThirdExpression() {
        return null;
    }

    public String getLiteralString() {
        return EMPTY_STRING;
    }

    public String getIdExpression() {
        return EMPTY_STRING;
    }

    public char[] getIdExpressionCharArray() {
        return EMPTY_CHAR_ARRAY;
    }

    public IASTTypeId getTypeId() {
        return null;
    }

    public IASTExpression.IASTNewExpressionDescriptor getNewExpressionDescriptor() {
        return null;
    }

    public IASTExpression findNewDescriptor(ITokenDuple finalDuple) {
        return null;
    }

    public void freeReferences(IReferenceManager manager) {
        if (this.references == null || this.references.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.references.size()) {
            manager.returnReference((IASTReference)this.references.get(i));
            ++i;
        }
        this.references.clear();
    }
}

