/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import org.eclipse.cdt.internal.core.parser.scanner2.CharTable;

public class CharArrayIntMap
extends CharTable {
    private int[] valueTable = new int[this.capacity()];
    public final int undefined;

    public CharArrayIntMap(int initialSize, int undefined) {
        super(initialSize);
        this.undefined = undefined;
    }

    protected void resize(int size) {
        int[] oldValueTable = this.valueTable;
        this.valueTable = new int[size];
        System.arraycopy(oldValueTable, 0, this.valueTable, 0, oldValueTable.length);
        super.resize(size);
    }

    public void clear() {
        super.clear();
        int i = 0;
        while (i < this.capacity()) {
            this.valueTable[i] = this.undefined;
            ++i;
        }
    }

    public int put(char[] key, int start, int length, int value) {
        int i = this.addIndex(key, start, length);
        int oldvalue = this.valueTable[i];
        this.valueTable[i] = value;
        return oldvalue;
    }

    public int put(char[] key, int value) {
        return this.put(key, 0, key.length, value);
    }

    public int get(char[] key, int start, int length) {
        int i = this.lookup(key, start, length);
        if (i >= 0) {
            return this.valueTable[i];
        }
        return this.undefined;
    }
}

