/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.resources.ScannerInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ScannerProvider
extends AbstractCExtension
implements IScannerInfoProvider,
IElementChangedListener {
    private static Map listeners;
    private static ScannerProvider fProvider;

    public static synchronized IScannerInfoProvider getInstance() {
        if (fProvider == null) {
            fProvider = new ScannerProvider();
            CoreModel.getDefault().addElementChangedListener(fProvider);
        }
        return fProvider;
    }

    private static Map getListeners() {
        if (listeners == null) {
            listeners = new HashMap();
        }
        return listeners;
    }

    protected static void notifyInfoListeners(IProject project, IScannerInfo info) {
        List listeners = (List)ScannerProvider.getListeners().get(project);
        if (listeners == null) {
            return;
        }
        IScannerInfoChangeListener[] observers = new IScannerInfoChangeListener[listeners.size()];
        listeners.toArray(observers);
        int i = 0;
        while (i < observers.length) {
            observers[i].changeNotification((IResource)project, info);
            ++i;
        }
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        IPath resPath = resource.getFullPath();
        ICProject cproject = CoreModel.getDefault().create(resource.getProject());
        try {
            if (cproject != null) {
                IPathEntry[] entries = cproject.getResolvedPathEntries();
                int k = 0;
                while (k < entries.length) {
                    switch (entries[k].getEntryKind()) {
                        case 4: {
                            IIncludeEntry incEntry = (IIncludeEntry)entries[k];
                            if (!CoreModelUtil.isExcluded(resPath, incEntry.fullExclusionPatternChars())) break;
                            entries[k] = null;
                            break;
                        }
                        case 6: {
                            IMacroEntry macEntry = (IMacroEntry)entries[k];
                            if (!CoreModelUtil.isExcluded(resPath, macEntry.fullExclusionPatternChars())) break;
                            entries[k] = null;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            entries[k] = null;
                        }
                    }
                    ++k;
                }
                int count = resPath.segmentCount();
                ArrayList<String> includeList = new ArrayList<String>();
                HashMap<String, String> symbolMap = new HashMap<String, String>();
                int i = 0;
                while (i < count) {
                    IPath newPath = resPath.removeLastSegments(i);
                    int j = 0;
                    while (j < entries.length) {
                        IPathEntry entry;
                        IPath otherPath;
                        if (entries[j] != null && newPath.equals((Object)(otherPath = (entry = entries[j]).getPath()))) {
                            IMacroEntry macro;
                            String key;
                            if (entry.getEntryKind() == 4) {
                                IIncludeEntry include = (IIncludeEntry)entry;
                                includeList.add(include.getFullIncludePath().toOSString());
                            } else if (entry.getEntryKind() == 6 && !symbolMap.containsKey(key = (macro = (IMacroEntry)entry).getMacroName())) {
                                symbolMap.put(key, macro.getMacroValue());
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < entries.length) {
                    ICProject refCProject;
                    IResource res;
                    IPathEntry entry = entries[i];
                    if (entry != null && entry.getEntryKind() == 2 && (res = resource.getWorkspace().getRoot().findMember(entry.getPath())) != null && res.getType() == 4 && (refCProject = CoreModel.getDefault().create((IProject)res)) != null) {
                        IPathEntry[] projEntries = refCProject.getResolvedPathEntries();
                        int j = 0;
                        while (j < projEntries.length) {
                            IPathEntry projEntry = projEntries[j];
                            if (projEntry.isExported()) {
                                IMacroEntry macro;
                                String key;
                                if (projEntry.getEntryKind() == 4) {
                                    IIncludeEntry include = (IIncludeEntry)projEntry;
                                    includeList.add(include.getFullIncludePath().toOSString());
                                } else if (projEntry.getEntryKind() == 6 && !symbolMap.containsKey(key = (macro = (IMacroEntry)entry).getMacroName())) {
                                    symbolMap.put(key, macro.getMacroValue());
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                String[] includes = new String[includeList.size()];
                includeList.toArray(includes);
                return new ScannerInfo(includes, symbolMap);
            }
        }
        catch (CModelException cModelException) {}
        return new ScannerInfo(null, null);
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        if (resource == null || listener == null) {
            return;
        }
        IProject project = resource.getProject();
        Map map = ScannerProvider.getListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
            map.put(project, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        if (resource == null || listener == null) {
            return;
        }
        IProject project = resource.getProject();
        Map map = ScannerProvider.getListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException cModelException) {}
    }

    protected boolean isPathEntryChange(ICElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && ((flags & 0x800) != 0 || (flags & 0x400) != 0 || (flags & 0x40000) != 0);
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        ICElement element = delta.getElement();
        if (this.isPathEntryChange(delta)) {
            IResource res = element.getResource();
            IProject project = element.getCProject().getProject();
            if (res == null) {
                res = project;
            }
            IScannerInfo info = this.getScannerInformation(res);
            ScannerProvider.notifyInfoListeners(project, info);
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }
}

