/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class TemplateParameterManager {
    private final int counterId;
    private List list;
    private int emptySegmentCount;
    private static final int NUMBER_OF_INSTANCES = 8;
    private static final boolean[] instancesUsed = new boolean[8];
    private static final TemplateParameterManager[] counters = new TemplateParameterManager[8];
    private static int counter = 8;

    static {
        int i = 0;
        while (i < 8) {
            TemplateParameterManager.instancesUsed[i] = false;
            TemplateParameterManager.counters[i] = new TemplateParameterManager(i);
            ++i;
        }
    }

    protected void reset() {
        this.list = Collections.EMPTY_LIST;
        this.emptySegmentCount = 0;
    }

    private TemplateParameterManager(int i) {
        this.reset();
        this.counterId = i;
    }

    public List getTemplateArgumentsList() {
        return this.list;
    }

    public void addSegment(List inputSegment) {
        if (inputSegment == null) {
            if (this.list == Collections.EMPTY_LIST) {
                ++this.emptySegmentCount;
            } else {
                this.list.add(null);
            }
        } else {
            if (this.list == Collections.EMPTY_LIST) {
                this.list = new ArrayList();
                int i = 0;
                while (i < this.emptySegmentCount) {
                    this.list.add(null);
                    ++i;
                }
            }
            this.list.add(inputSegment);
        }
    }

    public static synchronized TemplateParameterManager getInstance() {
        int index = TemplateParameterManager.findFreeCounter();
        if (index == -1) {
            return new TemplateParameterManager(++counter);
        }
        TemplateParameterManager.instancesUsed[index] = true;
        return counters[index];
    }

    public static synchronized void returnInstance(TemplateParameterManager c) {
        if (c.counterId > 0 && c.counterId < 8) {
            TemplateParameterManager.instancesUsed[c.counterId] = false;
        }
        c.reset();
    }

    private static int findFreeCounter() {
        int i = 0;
        while (i < 8) {
            if (!instancesUsed[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

