/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IReferenceManager;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTNamespaceDefinition
extends ASTScope
implements IASTNamespaceDefinition {
    private final ASTQualifiedNamedElement qualifiedName;
    private List declarations = null;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTNamespaceDefinition(ISymbol namespaceSymbol, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, char[] filename) {
        super(namespaceSymbol);
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), namespaceSymbol.getName());
        this.fn = filename;
    }

    public String getName() {
        return String.valueOf(this.symbol.getName());
    }

    public void acceptElement(ISourceElementRequestor requestor, IReferenceManager manager) {
    }

    public void enterScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.enterNamespaceDefinition(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor, IReferenceManager manager) {
        try {
            requestor.exitNamespaceDefinition(this);
        }
        catch (Exception exception) {}
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public Iterator getDeclarations() {
        if (this.declarations != null) {
            return this.declarations.iterator();
        }
        return super.getDeclarations();
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public void initDeclarations() {
        this.declarations = new ArrayList(0);
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getNameCharArray() {
        return this.symbol.getName();
    }
}

