/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import org.eclipse.cdt.internal.core.parser.pst.BasicTypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TemplateParameterTypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class TypeInfoProvider {
    private static final int BASIC = 0;
    private static final int TYPE = 1;
    private static final int TEMPLATE = 2;
    private static final int POOL_SIZE = 16;
    private final ITypeInfo[][] pool = new ITypeInfo[16][3];
    private final boolean[][] free = new boolean[16][3];
    private final int[] firstFreeHint = new int[3];
    private ITypeInfo.eType type;
    private ISymbol typeSymbol;
    private int bits;
    private Object defaultObj;
    private boolean hasDef;
    private ITypeInfo.eType templateParamType;

    protected TypeInfoProvider() {
        int i = 0;
        while (i < 16) {
            this.pool[i] = new ITypeInfo[]{TypeInfoProvider.newInfo(ITypeInfo.t_void, true), TypeInfoProvider.newInfo(ITypeInfo.t_type, true), TypeInfoProvider.newInfo(ITypeInfo.t_templateParameter, true)};
            this.free[i] = new boolean[]{true, true, true};
            ++i;
        }
    }

    public ITypeInfo getTypeInfo(ITypeInfo.eType t) {
        int idx = 0;
        if (t == ITypeInfo.t_type || t == ITypeInfo.t_enumerator) {
            idx = 1;
        } else if (t == ITypeInfo.t_templateParameter) {
            idx = 2;
        }
        ITypeInfo returnType = null;
        int i = this.firstFreeHint[idx];
        while (i < 16) {
            if (this.free[i][idx]) {
                this.free[i][idx] = false;
                this.firstFreeHint[idx] = i + 1;
                returnType = this.pool[i][idx];
                break;
            }
            ++i;
        }
        if (returnType == null) {
            returnType = t == ITypeInfo.t_type ? new TypeInfo() : (t == ITypeInfo.t_templateParameter ? new TemplateParameterTypeInfo() : new BasicTypeInfo());
        }
        returnType.setType(t);
        return returnType;
    }

    public void returnTypeInfo(ITypeInfo t) {
        int idx = 0;
        if (t instanceof TemplateParameterTypeInfo) {
            idx = 2;
        } else if (t instanceof TypeInfo) {
            idx = 1;
        }
        int i = 0;
        while (i < 16) {
            if (this.pool[i][idx] == t) {
                t.clear();
                this.free[i][idx] = true;
                if (i < this.firstFreeHint[idx]) {
                    this.firstFreeHint[idx] = i;
                }
                return;
            }
            ++i;
        }
    }

    public int numAllocated() {
        int num = 0;
        int i = 0;
        while (i < 16) {
            num += (this.free[i][0] ? 0 : 1) + (this.free[i][1] ? 0 : 1) + (this.free[i][2] ? 0 : 1);
            ++i;
        }
        return num;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo topInfo) {
        ITypeInfo newInfo = TypeInfoProvider.newInfo(topInfo.getType(), topInfo.getDefault() != null);
        newInfo.copy(topInfo);
        return newInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType type, int bits, ISymbol typeSymbol, ITypeInfo.PtrOp ptrOp, boolean hasDefault) {
        ITypeInfo newInfo = TypeInfoProvider.newTypeInfo(type, bits, ptrOp, hasDefault);
        newInfo.setTypeSymbol(typeSymbol);
        return newInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType type, int bits, ISymbol typeSymbol) {
        ITypeInfo newInfo = TypeInfoProvider.newTypeInfo(type);
        newInfo.setTypeBits(bits);
        newInfo.setTypeSymbol(typeSymbol);
        return newInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType type, int bits, ITypeInfo.PtrOp ptrOp, boolean hasDefault) {
        ITypeInfo newInfo = TypeInfoProvider.newTypeInfo(type);
        newInfo.setTypeBits(bits);
        newInfo.addPtrOperator(ptrOp);
        newInfo.setHasDefault(hasDefault);
        return newInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType type) {
        ITypeInfo newInfo = TypeInfoProvider.newInfo(type, false);
        newInfo.setType(type);
        return newInfo;
    }

    public static final ITypeInfo newTypeInfo(ITypeInfo.eType type, int bits, ISymbol symbol, ITypeInfo.PtrOp op, Object def) {
        ITypeInfo newInfo = TypeInfoProvider.newInfo(type, def != null);
        newInfo.setType(type);
        newInfo.setTypeBits(bits);
        newInfo.setDefault(def);
        newInfo.setTypeSymbol(symbol);
        newInfo.addPtrOperator(op);
        return newInfo;
    }

    public static final ITypeInfo newTypeInfo() {
        return new BasicTypeInfo();
    }

    public void setType(ITypeInfo.eType t) {
        this.type = t;
    }

    public void setTypeSymbol(ISymbol s) {
        this.typeSymbol = s;
    }

    public void setTypeBits(int b) {
        this.bits = b;
    }

    public void setHasDef(boolean b) {
        this.hasDef = b;
    }

    public void setDefaultObj(Object obj) {
        this.defaultObj = obj;
    }

    public void setTemplateParameterType(ITypeInfo.eType t) {
        this.templateParamType = t;
    }

    public void setBit(boolean b, int mask) {
        this.bits = b ? (this.bits |= mask) : (this.bits &= ~mask);
    }

    public void beginTypeConstruction() {
        this.type = ITypeInfo.t_undef;
        this.typeSymbol = null;
        this.bits = 0;
        this.defaultObj = null;
        this.templateParamType = null;
        this.hasDef = false;
    }

    public ITypeInfo completeConstruction() {
        ITypeInfo newInfo = TypeInfoProvider.newTypeInfo(this.type, this.bits, this.typeSymbol, null, this.defaultObj);
        newInfo.setHasDefault(this.hasDef);
        if (this.templateParamType != null) {
            newInfo.setTemplateParameterType(this.templateParamType);
        }
        this.beginTypeConstruction();
        return newInfo;
    }

    private static final ITypeInfo newInfo(ITypeInfo.eType type, boolean def) {
        BasicTypeInfo newInfo = null;
        newInfo = type == ITypeInfo.t_type || type == ITypeInfo.t_enumerator ? (def ? new TypeInfo(){
            private Object _defObj;

            public void copy(ITypeInfo t) {
                super.copy(t);
                this._defObj = t.getDefault();
            }

            public void setDefault(Object t) {
                this._defObj = t;
            }

            public Object getDefault() {
                return this._defObj;
            }
        } : new TypeInfo()) : (type == ITypeInfo.t_templateParameter ? (def ? new TemplateParameterTypeInfo(){
            private Object _defObj;

            public void copy(ITypeInfo t) {
                super.copy(t);
                this._defObj = t.getDefault();
            }

            public void setDefault(Object t) {
                this._defObj = t;
            }

            public Object getDefault() {
                return this._defObj;
            }
        } : new TemplateParameterTypeInfo()) : (def ? new BasicTypeInfo(){
            private Object _defObj;

            public void copy(ITypeInfo t) {
                super.copy(t);
                this._defObj = t.getDefault();
            }

            public void setDefault(Object t) {
                this._defObj = t;
            }

            public Object getDefault() {
                return this._defObj;
            }
        } : new BasicTypeInfo()));
        return newInfo;
    }
}

