/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.util.Collections;
import java.util.Observable;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.mi.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class SolibSearchPathBlock
extends Observable {
    private Shell fShell;
    private SolibSearchPathListDialogField fDirList;

    public SolibSearchPathBlock() {
        String[] stringArray = new String[6];
        stringArray[0] = MIUIMessages.getString("SolibSearchPathBlock.0");
        stringArray[2] = MIUIMessages.getString("SolibSearchPathBlock.1");
        stringArray[3] = MIUIMessages.getString("SolibSearchPathBlock.2");
        stringArray[5] = MIUIMessages.getString("SolibSearchPathBlock.3");
        String[] buttonLabels = stringArray;
        IListAdapter listAdapter = new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
                SolibSearchPathBlock.this.buttonPressed(index);
            }

            public void selectionChanged(DialogField field) {
            }
        };
        this.fDirList = new SolibSearchPathListDialogField(listAdapter, buttonLabels, (ILabelProvider)new LabelProvider());
        this.fDirList.setLabelText(MIUIMessages.getString("SolibSearchPathBlock.4"));
        this.fDirList.setUpButtonIndex(2);
        this.fDirList.setDownButtonIndex(3);
        this.fDirList.setRemoveButtonIndex(5);
    }

    public void createBlock(Composite parent) {
        this.fShell = parent.getShell();
        Composite comp = ControlFactory.createCompositeEx((Composite)parent, (int)2, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)comp.getLayout()).marginHeight = 0;
        ((GridLayout)comp.getLayout()).marginWidth = 0;
        comp.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)comp);
        this.fDirList.doFillIntoGrid(comp, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fDirList.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fDirList.getLabelControl(null), converter.convertWidthInCharsToPixels(30));
        LayoutUtil.setHorizontalGrabbing(this.fDirList.getListControl(null));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.fDirList != null) {
            try {
                this.fDirList.addElements(configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST));
            }
            catch (CoreException coreException) {}
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fDirList != null) {
            configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, this.fDirList.getElements());
        }
    }

    protected void buttonPressed(int index) {
        if (index == 0) {
            this.addDirectory();
        }
        this.setChanged();
        this.notifyObservers();
    }

    protected Shell getShell() {
        return this.fShell;
    }

    private void addDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(MIUIMessages.getString("SolibSearchPathBlock.5"));
        String res = dialog.open();
        if (res != null) {
            this.fDirList.addElement(res);
        }
    }

    public void dispose() {
        this.deleteObservers();
    }

    public class SolibSearchPathListDialogField
    extends ListDialogField {
        public SolibSearchPathListDialogField(IListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
            super(adapter, buttonLabels, lprovider);
        }

        protected boolean managedButtonPressed(int index) {
            boolean result = super.managedButtonPressed(index);
            if (result) {
                SolibSearchPathBlock.this.buttonPressed(index);
            }
            return result;
        }
    }
}

