/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.wizards.ConfigurationContentProvider;
import org.eclipse.cdt.managedbuilder.ui.wizards.ConfigurationLabelProvider;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectWizard;
import org.eclipse.cdt.ui.wizards.NewCProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.help.WorkbenchHelp;

public class CProjectPlatformPage
extends WizardPage {
    private static final String PREFIX = "PlatformBlock";
    private static final String LABEL = "PlatformBlock.label";
    private static final String TIP = "PlatformBlock.tip";
    private static final String CONFIG_LABEL = "PlatformBlock.label.configs";
    private static final String SHOWALL_LABEL = "PlatformBlock.label.showall";
    private static final String TARGET_LABEL = "PlatformBlock.label.platform";
    private static final String TARGET_TIP = "PlatformBlock.tip.platform";
    protected NewManagedProjectWizard parentWizard;
    protected Combo platformSelection;
    private ArrayList selectedConfigurations;
    protected ITarget selectedTarget;
    protected Button showAll;
    protected CheckboxTableViewer tableViewer;
    protected String[] targetNames;
    protected ArrayList targets;

    public CProjectPlatformPage(String pageName, NewManagedProjectWizard parentWizard) {
        super(pageName);
        this.setPageComplete(false);
        this.selectedTarget = null;
        this.selectedConfigurations = new ArrayList(0);
        this.parentWizard = parentWizard;
    }

    public boolean canFlipToNextPage() {
        return this.validatePage();
    }

    private void createConfigSelectionGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label configLabel = new Label(composite, 16384);
        configLabel.setFont(composite.getFont());
        configLabel.setText(ManagedBuilderUIMessages.getResourceString(CONFIG_LABEL));
        Table table = new Table(composite, 2854);
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        table.setHeaderVisible(false);
        table.setLayout((Layout)tableLayout);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CProjectPlatformPage.this.handleConfigurationSelectionChange();
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.new_proj_wiz_m_target");
        this.createTargetSelectGroup(composite);
        this.createConfigSelectionGroup(composite);
        this.createShowAllGroup(composite);
        this.populateTargets();
        this.platformSelection.select(0);
        this.handleTargetSelection();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createShowAllGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.showAll = new Button(composite, 16416);
        this.showAll.setFont(composite.getFont());
        this.showAll.setText(ManagedBuilderUIMessages.getResourceString(SHOWALL_LABEL));
        this.showAll.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CProjectPlatformPage.this.populateTargets();
                CProjectPlatformPage.this.platformSelection.select(0);
                CProjectPlatformPage.this.handleTargetSelection();
            }
        });
        this.showAll.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CProjectPlatformPage.this.showAll = null;
            }
        });
    }

    private void createTargetSelectGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label platformLabel = new Label(composite, 16384);
        platformLabel.setFont(composite.getFont());
        platformLabel.setText(ManagedBuilderUIMessages.getResourceString(TARGET_LABEL));
        this.platformSelection = new Combo(composite, 2060);
        this.platformSelection.setFont(composite.getFont());
        this.platformSelection.setToolTipText(ManagedBuilderUIMessages.getResourceString(TARGET_TIP));
        this.platformSelection.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CProjectPlatformPage.this.handleTargetSelection();
            }
        });
        this.platformSelection.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CProjectPlatformPage.this.platformSelection = null;
            }
        });
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        this.platformSelection.setLayoutData((Object)gd);
    }

    public IProject getProject() {
        return ((NewCProjectWizard)this.getWizard()).getNewProject();
    }

    public IConfiguration[] getSelectedConfigurations() {
        return this.selectedConfigurations.toArray(new IConfiguration[this.selectedConfigurations.size()]);
    }

    public ITarget getSelectedTarget() {
        return this.selectedTarget;
    }

    private void handleConfigurationSelectionChange() {
        this.selectedConfigurations.clear();
        this.selectedConfigurations.addAll(Arrays.asList(this.tableViewer.getCheckedElements()));
        this.setPageComplete(this.validatePage());
    }

    protected void handleTargetSelection() {
        int index;
        if (this.platformSelection != null && (index = this.platformSelection.getSelectionIndex()) != -1 && this.selectedTarget != (ITarget)this.targets.get(index)) {
            this.selectedTarget = (ITarget)this.targets.get(index);
            this.parentWizard.updateTargetProperties();
        }
        this.populateConfigurations();
        this.setPageComplete(this.validatePage());
    }

    private void populateConfigurations() {
        this.tableViewer.setInput((Object)this.selectedTarget);
        this.tableViewer.setAllChecked(true);
        this.handleConfigurationSelectionChange();
    }

    private void populateTargetNames() {
        this.targetNames = new String[this.targets.size()];
        ListIterator iter = this.targets.listIterator();
        int index = 0;
        while (iter.hasNext()) {
            this.targetNames[index++] = ((ITarget)iter.next()).getName();
        }
        this.platformSelection.removeAll();
        this.platformSelection.setItems(this.targetNames);
    }

    private void populateTargets() {
        ITarget[] allTargets = ManagedBuildManager.getDefinedTargets(null);
        this.targets = new ArrayList();
        String os = Platform.getOS();
        String arch = Platform.getOSArch();
        int index = 0;
        while (index < allTargets.length) {
            ITarget target = allTargets[index];
            if (!target.isAbstract() && !target.isTestTarget()) {
                if (this.showAll != null && this.showAll.getSelection()) {
                    this.targets.add(target);
                } else {
                    List<String> targetArchList;
                    List<String> targetOSList = Arrays.asList(target.getTargetOSList());
                    if ((targetOSList.contains("all") || targetOSList.contains(os)) && ((targetArchList = Arrays.asList(target.getTargetArchList())).contains("all") || targetArchList.contains(arch))) {
                        this.targets.add(target);
                    }
                }
            }
            ++index;
        }
        this.targets.trimToSize();
        this.populateTargetNames();
    }

    private boolean validatePage() {
        if (this.tableViewer.getCheckedElements().length > 0) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(ManagedBuilderUIMessages.getResourceString("PlatformBlock.message.error.noconfigs"));
        return false;
    }
}

