/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.ICUpdateManager;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractRefreshActionDelegate;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractAutoRefreshActionDelegate
extends AbstractRefreshActionDelegate
implements Observer {
    protected void doAction() throws DebugException {
        ICUpdateManager um;
        IStructuredSelection selection;
        IAction action = this.getAction();
        if (action != null && !(selection = this.getSelection()).isEmpty() && (um = this.getUpdateManager(selection.getFirstElement())) != null) {
            um.setAutoModeEnabled(action.isChecked());
        }
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            boolean enabled = false;
            boolean checked = false;
            IStructuredSelection selection = this.getSelection();
            if (!selection.isEmpty()) {
                ICUpdateManager um = this.getUpdateManager(selection.getFirstElement());
                if (um != null && um.canUpdate()) {
                    enabled = true;
                }
                if (um != null && um.getAutoModeEnabled()) {
                    checked = true;
                }
            }
            action.setEnabled(enabled);
            action.setChecked(checked);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ICUpdateManager um;
        IStructuredSelection ss = this.getSelection();
        if (!ss.isEmpty() && (um = this.getUpdateManager(ss.getFirstElement())) instanceof Observable) {
            ((Observable)um).deleteObserver(this);
        }
        super.selectionChanged(part, selection);
        ss = this.getSelection();
        if (!ss.isEmpty() && (um = this.getUpdateManager(ss.getFirstElement())) instanceof Observable) {
            ((Observable)um).addObserver(this);
        }
    }

    public void dispose() {
        ICUpdateManager um;
        IStructuredSelection ss = this.getSelection();
        if (!ss.isEmpty() && (um = this.getUpdateManager(ss.getFirstElement())) instanceof Observable) {
            ((Observable)um).deleteObserver(this);
        }
        super.dispose();
    }

    public void update(Observable o, Object arg) {
        this.update();
    }
}

