/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.AbstractLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CFunctionBreakpoint
extends AbstractLineBreakpoint
implements ICFunctionBreakpoint {
    private static final String C_FUNCTION_BREAKPOINT = "org.eclipse.cdt.debug.core.cFunctionBreakpointMarker";

    public CFunctionBreakpoint() {
    }

    public CFunctionBreakpoint(IResource resource, Map attributes, boolean add) throws CoreException {
        super(resource, CFunctionBreakpoint.getMarkerType(), attributes, add);
    }

    public static String getMarkerType() {
        return C_FUNCTION_BREAKPOINT;
    }

    protected String getMarkerMessage() throws CoreException {
        String function;
        StringBuffer sb = new StringBuffer(BreakpointMessages.getString("CFunctionBreakpoint.2"));
        String name = this.ensureMarker().getResource().getName();
        if (name != null && name.length() > 0) {
            sb.append(' ');
            sb.append(name);
        }
        if ((function = this.getFunction()) != null && function.trim().length() > 0) {
            sb.append(MessageFormat.format(BreakpointMessages.getString("CFunctionBreakpoint.3"), function.trim()));
        }
        sb.append(this.getConditionText());
        return sb.toString();
    }
}

