/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.make.ui.dialogs.ManageDefinedSymbolsDialog;
import org.eclipse.cdt.make.ui.dialogs.ManageIncludePathsDialog;
import org.eclipse.cdt.make.ui.dialogs.ScannerConfigOptionsDialog;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPathInfoBlock
extends AbstractCOptionPage {
    private static final int PROJECT_LIST_MULTIPLIER = 15;
    private static final int INITIAL_LIST_WIDTH = 60;
    private static final String PREF_SYMBOLS = "ScannerSymbols";
    private static final String PREF_INCLUDES = "ScannerIncludes";
    private static final String PREFIX = "BuildPathInfoBlock";
    private static final String LABEL = "BuildPathInfoBlock.label";
    private static final String PATHS = "BuildPathInfoBlock.paths";
    private static final String SYMBOLS = "BuildPathInfoBlock.symbols";
    private static final String MANAGE = "BuildPropertyCommon.label.manage";
    private static final String SC_GROUP_LABEL = "BuildPathInfoBlock.scGroup.label";
    private static final String SC_ENABLED_LABEL = "BuildPathInfoBlock.scGroup.enabled.label";
    private static final String SC_OPTIONS_LABEL = "BuildPathInfoBlock.scGroup.options.label";
    private static final String MISSING_BUILDER_MSG = "ScannerConfigOptionsDialog.label.missingBuilderInformation";
    private Button scEnabledButton;
    private Button scOptionsButton;
    private List pathList;
    private List symbolList;
    private Composite pathButtonComp;
    private Button managePathsButton;
    private Composite symbolButtonComp;
    private Button manageSymbolsButton;
    private ScannerConfigOptionsDialog scOptionsDialog;
    private ManageIncludePathsDialog manageIncludesDialog;
    private ManageDefinedSymbolsDialog manageSymbolsDialog;
    private boolean needsSCNature = false;

    public BuildPathInfoBlock() {
        super(MakeUIPlugin.getResourceString(LABEL));
        this.setDescription(MakeUIPlugin.getResourceString("BuildPathInfoBlock.description"));
    }

    private void createPathListButtons(Composite parent) {
        if (this.manageIncludesDialog == null) {
            this.manageIncludesDialog = new ManageIncludePathsDialog(this.getShell(), this.getContainer());
        }
        this.pathButtonComp = ControlFactory.createComposite((Composite)parent, (int)1);
        ((GridData)this.pathButtonComp.getLayoutData()).verticalAlignment = 1;
        ((GridData)this.pathButtonComp.getLayoutData()).grabExcessHorizontalSpace = false;
        this.pathButtonComp.setFont(parent.getFont());
        this.managePathsButton = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)MakeUIPlugin.getResourceString(MANAGE));
        this.managePathsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleManagePaths();
            }
        });
        this.managePathsButton.setFont(parent.getFont());
        this.managePathsButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.managePathsButton);
    }

    protected void handleManagePaths() {
        if (this.manageIncludesDialog.open() == 0) {
            this.pathList.setItems(this.manageIncludesDialog.getManagedIncludes());
        }
    }

    private void createPathListControl(Composite parent, int numColumns) {
        this.pathList = new List(parent, 2820);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = numColumns - 1;
        gd.heightHint = BuildPathInfoBlock.getDefaultFontHeight((Control)this.pathList, 15);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.pathList.setLayoutData((Object)gd);
        this.pathList.setFont(parent.getFont());
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    private void createSymbolListButtons(Composite parent) {
        if (this.manageSymbolsDialog == null) {
            this.manageSymbolsDialog = new ManageDefinedSymbolsDialog(this.getShell(), this.getContainer());
        }
        this.symbolButtonComp = ControlFactory.createComposite((Composite)parent, (int)1);
        ((GridData)this.symbolButtonComp.getLayoutData()).verticalAlignment = 1;
        ((GridData)this.symbolButtonComp.getLayoutData()).grabExcessHorizontalSpace = false;
        this.symbolButtonComp.setFont(parent.getFont());
        this.manageSymbolsButton = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)MakeUIPlugin.getResourceString(MANAGE));
        this.manageSymbolsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleManageSymbols();
            }
        });
        this.manageSymbolsButton.setFont(parent.getFont());
        this.manageSymbolsButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.manageSymbolsButton);
    }

    protected void handleManageSymbols() {
        if (this.manageSymbolsDialog.open() == 0) {
            this.symbolList.setItems(this.manageSymbolsDialog.getManagedSymbols());
        }
    }

    private void createSymbolListControl(Composite parent, int numColumns) {
        this.symbolList = new List(parent, 2820);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = BuildPathInfoBlock.getDefaultFontHeight((Control)this.pathList, 15);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.symbolList.setLayoutData((Object)gd);
        this.symbolList.setFont(parent.getFont());
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        IProject project;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.scOptionsDialog.isInitialized()) {
            try {
                this.scOptionsDialog.performApply(monitor);
            }
            catch (CoreException coreException) {}
        }
        if ((project = this.getContainer().getProject()) != null) {
            monitor.beginTask(MakeUIPlugin.getResourceString("BuildPathInfoBlock.monitor.settingScannerInfo"), 3);
            IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(project);
            boolean changed = this.manageIncludesDialog.saveTo(info);
            monitor.worked(1);
            monitor.worked(1);
            if (changed |= this.manageSymbolsDialog.saveTo(info)) {
                MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(info);
            }
            monitor.done();
        } else {
            this.setIncludes(MakeCorePlugin.getDefault().getPluginPreferences());
            this.setSymbols(MakeCorePlugin.getDefault().getPluginPreferences());
        }
    }

    public void performDefaults() {
        this.scOptionsDialog.performDefaults();
        this.scEnabledButton.setSelection(this.scOptionsDialog.isScannerConfigDiscoveryEnabled());
        this.handleScannerConfigEnable();
        this.pathList.removeAll();
        this.symbolList.removeAll();
        this.manageIncludesDialog.restore();
        this.manageSymbolsDialog.restore();
        this.getContainer().updateContainer();
    }

    private void setSymbols(Preferences prefs) {
        prefs.setValue(PREF_SYMBOLS, this.stringArrayToString(this.getSymbolListContents()));
    }

    private void setIncludes(Preferences prefs) {
        prefs.setValue(PREF_INCLUDES, this.stringArrayToString(this.getPathListContents()));
    }

    private String stringArrayToString(String[] strings) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buf.append(strings[i]).append(';');
            ++i;
        }
        return buf.toString();
    }

    static String[] getSymbols(Preferences prefs) {
        String syms = prefs.getString(PREF_SYMBOLS);
        return BuildPathInfoBlock.parseStringToList(syms);
    }

    static String[] getIncludes(Preferences prefs) {
        String syms = prefs.getString(PREF_INCLUDES);
        return BuildPathInfoBlock.parseStringToList(syms);
    }

    private static String[] parseStringToList(String syms) {
        if (syms != null && syms.length() > 0) {
            StringTokenizer tok = new StringTokenizer(syms, ";");
            ArrayList<String> list = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    public void createControl(Composite parent) {
        int tabColumns = 3;
        Font font = parent.getFont();
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)tabColumns);
        ((GridLayout)composite.getLayout()).makeColumnsEqualWidth = false;
        composite.setFont(font);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.MAKE_PATH_SYMBOL_SETTINGS);
        this.createScannerConfigControls(composite, tabColumns);
        Label paths = ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString(PATHS));
        GridData gd = new GridData(768);
        gd.horizontalSpan = tabColumns;
        gd.grabExcessHorizontalSpace = false;
        paths.setLayoutData((Object)gd);
        paths.setFont(font);
        this.createPathListControl(composite, tabColumns);
        this.createPathListButtons(composite);
        Label symbols = ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString(SYMBOLS));
        gd = new GridData(768);
        gd.horizontalSpan = tabColumns;
        gd.grabExcessHorizontalSpace = false;
        symbols.setLayoutData((Object)gd);
        symbols.setFont(font);
        this.createSymbolListControl(composite, tabColumns);
        this.createSymbolListButtons(composite);
        this.setListContents();
    }

    private void createScannerConfigControls(Composite parent, int numColumns) {
        IProject project = this.getContainer().getProject();
        try {
            if (project != null && project.hasNature(MakeProjectNature.NATURE_ID) && !project.hasNature(ScannerConfigNature.NATURE_ID)) {
                this.needsSCNature = true;
            }
        }
        catch (CoreException coreException) {}
        if (this.scOptionsDialog == null) {
            this.scOptionsDialog = this.needsSCNature ? new ScannerConfigOptionsDialog(this.getContainer()) : new ScannerConfigOptionsDialog(this.getShell(), this.getContainer());
        }
        Group scGroup = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(SC_GROUP_LABEL), (int)numColumns);
        scGroup.setFont(parent.getFont());
        ((GridData)scGroup.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)scGroup.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)scGroup.getLayoutData()).horizontalAlignment = 4;
        ((GridLayout)scGroup.getLayout()).marginWidth = 7;
        if (!this.needsSCNature && !this.scOptionsDialog.isInitialized()) {
            ControlFactory.createLabel((Composite)scGroup, (String)MakeUIPlugin.getResourceString(MISSING_BUILDER_MSG));
            return;
        }
        this.scEnabledButton = ControlFactory.createCheckBox((Composite)scGroup, (String)MakeUIPlugin.getResourceString(SC_ENABLED_LABEL));
        this.scEnabledButton.setFont(parent.getFont());
        ((GridData)this.scEnabledButton.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.scEnabledButton.getLayoutData()).grabExcessHorizontalSpace = true;
        this.scEnabledButton.setSelection(this.needsSCNature ? false : this.scOptionsDialog.isScannerConfigDiscoveryEnabled());
        this.scEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleScannerConfigEnable();
            }
        });
        this.scOptionsButton = ControlFactory.createPushButton((Composite)scGroup, (String)MakeUIPlugin.getResourceString(SC_OPTIONS_LABEL));
        this.scOptionsButton.setFont(parent.getFont());
        ((GridData)this.scOptionsButton.getLayoutData()).grabExcessHorizontalSpace = false;
        SWTUtil.setButtonDimensionHint((Button)this.scOptionsButton);
        this.scOptionsButton.setEnabled(this.scEnabledButton.getSelection());
        this.scOptionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.scOptionsDialog.open();
            }
        });
    }

    protected void handleScannerConfigEnable() {
        boolean enable = this.scEnabledButton.getSelection();
        this.scOptionsButton.setEnabled(enable);
        if (enable && this.needsSCNature) {
            try {
                ScannerConfigNature.addScannerConfigNature((IProject)this.getContainer().getProject());
                this.scOptionsDialog = new ScannerConfigOptionsDialog(this.getShell(), this.getContainer());
                this.needsSCNature = false;
            }
            catch (CoreException e) {
                MakeCorePlugin.log((IStatus)e.getStatus());
            }
        }
        this.scOptionsDialog.setScannerConfigDiscoveryEnabled(enable);
    }

    private String[] getPathListContents() {
        return this.pathList.getItems();
    }

    private String[] getSymbolListContents() {
        return this.symbolList.getItems();
    }

    public boolean isValid() {
        return true;
    }

    private void setListContents() {
        IProject project = this.getContainer().getProject();
        if (project != null) {
            try {
                IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(project);
                this.pathList.setItems(ScannerConfigUtil.iPathArray2StringArray((IPath[])info.getIncludePaths()));
                LinkedHashMap discoveredSymbols = info.getSymbolMap();
                ArrayList activeSymbols = new ArrayList();
                activeSymbols.addAll(ScannerConfigUtil.scSymbolsSymbolEntryMap2List((Map)discoveredSymbols, (boolean)true));
                this.symbolList.setItems(activeSymbols.toArray(new String[activeSymbols.size()]));
            }
            catch (CoreException e) {
                MakeCorePlugin.log((Throwable)e);
            }
        }
    }

    static class SelectPathInputDialog
    extends InputDialog {
        public SelectPathInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button browse = this.createButton(parent, 3, MakeUIPlugin.getResourceString("BuildPathInfoBlock.button.browse"), true);
            browse.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SelectPathInputDialog this$1;
                {
                    this.this$1 = selectPathInputDialog;
                }

                public void widgetSelected(SelectionEvent ev) {
                    String dirname;
                    DirectoryDialog dialog = new DirectoryDialog(this.this$1.getShell(), 4096);
                    String currentName = SelectPathInputDialog.access$0(this.this$1).getText();
                    if (currentName != null && currentName.trim().length() != 0) {
                        dialog.setFilterPath(currentName);
                    }
                    if ((dirname = dialog.open()) != null) {
                        SelectPathInputDialog.access$0(this.this$1).setText(dirname);
                    }
                }
            });
        }

        static /* synthetic */ Text access$0(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getText();
        }
    }
}

