/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPListImageDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;

class CPElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private final Color inDirect = new Color((Device)Display.getDefault(), new RGB(170, 170, 170));
    private String fNewLabel = CPathEntryMessages.getString("CPElementLabelProvider.new");
    private String fCreateLabel = CPathEntryMessages.getString("CPElementLabelProvider.willbecreated");
    private ImageDescriptor fIncludeIcon;
    private ImageDescriptor fMacroIcon;
    private ImageDescriptor fLibWSrcIcon;
    private ImageDescriptor fLibIcon;
    private ImageDescriptor fFolderImage;
    private ImageDescriptor fOutputImage;
    private ImageDescriptor fProjectImage;
    private ImageDescriptor fContainerImage;
    private boolean bShowExported;
    private boolean bShowParentInfo;
    private ImageDescriptorRegistry fRegistry = CUIPlugin.getImageDescriptorRegistry();
    private CElementImageProvider fCImages = new CElementImageProvider();
    private static final Point SMALL_SIZE = new Point(16, 16);

    public CPElementLabelProvider() {
        this(true, false);
    }

    public CPElementLabelProvider(boolean showExported, boolean showParentInfo) {
        this.fLibIcon = CPluginImages.DESC_OBJS_ARCHIVE;
        this.fLibWSrcIcon = CPluginImages.DESC_OBJS_ARCHIVE_WSRC;
        this.fIncludeIcon = CPluginImages.DESC_OBJS_INCLUDES_FOLDER;
        this.fMacroIcon = CPluginImages.DESC_OBJS_MACRO;
        this.fFolderImage = CPluginImages.DESC_OBJS_SOURCE_ROOT;
        this.fOutputImage = CPluginImages.DESC_OBJS_CONTAINER;
        this.fContainerImage = CPluginImages.DESC_OBJS_LIBRARY;
        IWorkbench workbench = CUIPlugin.getDefault().getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        this.bShowExported = showExported;
        this.bShowParentInfo = showParentInfo;
    }

    public String getText(Object element) {
        if (element instanceof CPElement) {
            return this.getCPElementText((CPElement)element);
        }
        if (element instanceof CPElementAttribute) {
            return this.getCPElementAttributeText((CPElementAttribute)element);
        }
        if (element instanceof IPathEntry) {
            return this.getCPElementText(CPElement.createFromExisting((IPathEntry)element, null));
        }
        if (element instanceof CPElementGroup) {
            return this.getCPContainerGroupText((CPElementGroup)element);
        }
        return super.getText(element);
    }

    private String getCPContainerGroupText(CPElementGroup group) {
        switch (group.getEntryKind()) {
            case 4: {
                return CPathEntryMessages.getString("CPElementLabelProvider.Includes");
            }
            case 6: {
                return CPathEntryMessages.getString("CPElementLabelProvider.PreprocessorSymbols");
            }
            case 1: {
                return CPathEntryMessages.getString("CPElementLabelProvider.Libraries");
            }
            case -1: {
                if (group.getResource().getType() == 4) {
                    return group.getResource().getName();
                }
                return group.getResource().getProjectRelativePath().toString();
            }
        }
        return "";
    }

    public String getCPElementAttributeText(CPElementAttribute attrib) {
        IPath path;
        String notAvailable = CPathEntryMessages.getString("CPElementLabelProvider.none");
        StringBuffer buf = new StringBuffer();
        String key = attrib.getKey();
        if (key.equals("sourcepath")) {
            buf.append(CPathEntryMessages.getString("CPElementLabelProvider.source_attachment.label"));
            path = (IPath)attrib.getValue();
            if (path != null && !path.isEmpty()) {
                buf.append(this.getPathString(path, path.getDevice() != null));
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("rootpath")) {
            buf.append(CPathEntryMessages.getString("CPElementLabelProvider.source_attachment_root.label"));
            path = (IPath)attrib.getValue();
            if (path != null && !path.isEmpty()) {
                buf.append(path.toString());
            } else {
                buf.append(notAvailable);
            }
        }
        if (key.equals("exclusion")) {
            buf.append(CPathEntryMessages.getString("CPElementLabelProvider.exclusion_filter.label"));
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int i = 0;
                while (i < patterns.length) {
                    if (i > 0) {
                        buf.append(CPathEntryMessages.getString("CPElementLabelProvider.exclusion_filter_separator"));
                    }
                    buf.append(patterns[i].toString());
                    ++i;
                }
            } else {
                buf.append(notAvailable);
            }
        }
        return buf.toString();
    }

    public String getCPElementText(CPElement cpentry) {
        IPath path = cpentry.getPath();
        switch (cpentry.getEntryKind()) {
            case 1: {
                IPath libPath = (IPath)cpentry.getAttribute("librarypath");
                StringBuffer str = new StringBuffer();
                this.addBaseString(libPath, cpentry, str);
                this.addExport(cpentry, str);
                this.addParentInfo(cpentry, str);
                return str.toString();
            }
            case 2: {
                return path.lastSegment();
            }
            case 4: {
                IPath incPath = (IPath)cpentry.getAttribute("includepath");
                StringBuffer str = new StringBuffer();
                this.addBaseString(incPath, cpentry, str);
                this.addExport(cpentry, str);
                this.addParentInfo(cpentry, str);
                return str.toString();
            }
            case 6: {
                StringBuffer str = new StringBuffer(String.valueOf((String)cpentry.getAttribute("macroname")) + "=" + (String)cpentry.getAttribute("macrovalue"));
                this.addBaseString(null, cpentry, str);
                this.addExport(cpentry, str);
                this.addParentInfo(cpentry, str);
                return str.toString();
            }
            case 5: {
                StringBuffer str = new StringBuffer(path.toString());
                try {
                    IPathEntryContainer container = CoreModel.getPathEntryContainer((IPath)cpentry.getPath(), (ICProject)cpentry.getCProject());
                    if (container != null) {
                        str.setLength(0);
                        str.append(container.getDescription());
                    }
                }
                catch (CModelException cModelException) {}
                this.addExport(cpentry, str);
                return str.toString();
            }
            case 3: 
            case 7: {
                StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                IResource resource = cpentry.getResource();
                if (resource != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.getStatus().getSeverity() != 0) {
                        buf.append(this.fCreateLabel);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                }
                return buf.toString();
            }
        }
        return CPathEntryMessages.getString("CPElementLabelProvider.unknown_element.label");
    }

    private void addParentInfo(CPElement cpentry, StringBuffer str) {
        CPElement parent;
        if (this.bShowParentInfo && (parent = cpentry.getParentContainer()) != null) {
            str.append(" [");
            try {
                IPathEntryContainer container = CoreModel.getPathEntryContainer((IPath)cpentry.getPath(), (ICProject)cpentry.getCProject());
                if (container != null) {
                    str.append(container.getDescription());
                }
            }
            catch (CModelException cModelException) {
                str.append(parent.getPath());
            }
            str.append(']');
        }
    }

    private void addExport(CPElement cpentry, StringBuffer str) {
        if (this.bShowExported && cpentry.isExported()) {
            str.append(' ');
            str.append(CPathEntryMessages.getString("CPElementLabelProvider.export.label"));
        }
    }

    private void addBaseString(IPath endPath, CPElement cpentry, StringBuffer str) {
        IPath baseRef = (IPath)cpentry.getAttribute("base-ref");
        if (!baseRef.isEmpty()) {
            if (baseRef.isAbsolute()) {
                IPath path = baseRef;
                if (endPath != null) {
                    path = path.append(endPath);
                }
                str.append(path.makeRelative().toOSString());
            } else {
                if (endPath != null) {
                    str.append(endPath.toOSString());
                }
                str.append(" - (");
                try {
                    IPathEntryContainer container = CoreModel.getPathEntryContainer((IPath)baseRef, (ICProject)cpentry.getCProject());
                    if (container != null) {
                        str.append(container.getDescription());
                    }
                }
                catch (CModelException cModelException) {}
                str.append(')');
            }
        } else {
            IPath path = (IPath)cpentry.getAttribute("base-path");
            if (!path.isEmpty()) {
                if (endPath != null) {
                    path = path.append(endPath);
                }
                str.insert(0, path.toOSString());
            } else if (endPath != null) {
                str.insert(0, endPath.toOSString());
            }
        }
    }

    private String getPathString(IPath path, boolean isExternal) {
        return isExternal ? path.toOSString() : path.makeRelative().toString();
    }

    private ImageDescriptor getCPElementBaseImage(CPElement cpentry) {
        switch (cpentry.getEntryKind()) {
            case 7: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fOutputImage;
            }
            case 3: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fFolderImage;
            }
            case 1: {
                IPath path = (IPath)cpentry.getAttribute("sourcepath");
                if (path == null || path.isEmpty()) {
                    return this.fLibIcon;
                }
                return this.fLibWSrcIcon;
            }
            case 2: {
                return this.fProjectImage;
            }
            case 5: {
                return this.fContainerImage;
            }
            case 4: {
                return this.fIncludeIcon;
            }
            case 6: {
                return this.fMacroIcon;
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof CPElement) {
            CPElement cpentry = (CPElement)element;
            Object imageDescriptor = this.getCPElementBaseImage(cpentry);
            if (imageDescriptor != null) {
                switch (cpentry.getStatus().getSeverity()) {
                    case 2: {
                        imageDescriptor = new CPListImageDescriptor((ImageDescriptor)imageDescriptor, 1, SMALL_SIZE);
                        break;
                    }
                    case 4: {
                        imageDescriptor = new CPListImageDescriptor((ImageDescriptor)imageDescriptor, 2, SMALL_SIZE);
                    }
                }
                if (cpentry.getInherited() != null) {
                    imageDescriptor = new CPListImageDescriptor((ImageDescriptor)imageDescriptor, 4, SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)imageDescriptor);
            }
        } else if (element instanceof CPElementAttribute) {
            String key = ((CPElementAttribute)element).getKey();
            if (key.equals("sourcepath")) {
                return this.fRegistry.get(CPluginImages.DESC_OBJS_SOURCE_ATTACH_ATTRIB);
            }
            if (key.equals("exclusion")) {
                return CPluginImages.get("org.eclipse.cdt.ui.exclusion_filter_attrib.gif");
            }
        } else {
            if (element instanceof IPathEntry) {
                return this.getImage(CPElement.createFromExisting((IPathEntry)element, null));
            }
            if (element instanceof CPElementGroup) {
                switch (((CPElementGroup)element).getEntryKind()) {
                    case 4: {
                        return CPluginImages.get("org.eclipse.cdt.ui.includes_container.gif");
                    }
                    case 6: {
                        return this.fRegistry.get(this.fMacroIcon);
                    }
                    case 1: {
                        return CPluginImages.get("org.eclipse.cdt.ui.lib_obj.gif");
                    }
                    case -1: {
                        return this.fCImages.getImageLabel(((CPElementGroup)element).getResource(), 2);
                    }
                }
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof CPElement && ((CPElement)element).getInherited() != null) {
            return this.inDirect;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

