/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Util
implements ICLogConstants {
    public static boolean VERBOSE_PARSER = false;
    public static boolean VERBOSE_SCANNER = false;
    public static boolean VERBOSE_MODEL = false;

    private Util() {
    }

    public static StringBuffer getContent(IFile file) throws IOException {
        StringBuffer stringBuffer;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
        try {
            char[] b = Util.getInputStreamAsCharArray(stream, -1, null);
            stringBuffer = new StringBuffer(b.length).append(b);
            Object var3_5 = null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
        catch (IOException iOException) {}
        return stringBuffer;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = new char[]{};
            int contentsLength = 0;
            int charsRead = -1;
            do {
                int available;
                if (contentsLength + (available = stream.available()) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + available];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((charsRead = reader.read(contents, contentsLength, available)) <= 0) continue;
                contentsLength += charsRead;
            } while (charsRead > 0);
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, 0, contents, 0, len);
            }
        }
        return contents;
    }

    public static void save(StringBuffer buffer, IFile file) throws CoreException {
        byte[] bytes = buffer.toString().getBytes();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        boolean force = true;
        file.setContents((InputStream)stream, force, true, null);
    }

    public static char[] getResourceContentsAsCharArray(IFile file) throws CModelException {
        return Util.getResourceContentsAsCharArray(file, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile file, String encoding) throws CModelException {
        char[] cArray;
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new CModelException(e, 969);
        }
        try {
            try {
                cArray = Util.getInputStreamAsCharArray(stream, -1, encoding);
                Object var4_6 = null;
            }
            catch (IOException e) {
                throw new CModelException(e, 985);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)stream).close();
        return cArray;
    }

    public static void log(Throwable e, String message, ICLogConstants.LogConst logType) {
        Status status = new Status(4, "org.eclipse.cdt.core", 4, message, e);
        Util.log((IStatus)status, logType);
    }

    public static void log(IStatus status, ICLogConstants.LogConst logType) {
        if (logType.equals(ICLogConstants.PDE)) {
            CCorePlugin.getDefault().getLog().log(status);
        } else if (logType.equals(ICLogConstants.CDT)) {
            CCorePlugin.getDefault().cdtLog.log(status);
        }
    }

    public static void log(String message, ICLogConstants.LogConst logType) {
        Status status = new Status(1, "org.eclipse.cdt.core", 1, message, null);
        Util.log((IStatus)status, logType);
    }

    public static void debugLog(String message, IDebugLogConstants.DebugLogConstant client) {
        Util.debugLog(message, client, true);
    }

    public static void debugLog(String message, IDebugLogConstants.DebugLogConstant client, boolean addTimeStamp) {
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        if (CCorePlugin.getDefault().isDebugging() && Util.isActive(client)) {
            if (addTimeStamp) {
                message = MessageFormat.format("[{0}] {1}", new Long(System.currentTimeMillis()), message);
            }
            while (message.length() > 100) {
                String partial = message.substring(0, 100);
                message = message.substring(100);
                System.out.println(String.valueOf(partial) + "\\");
            }
            if (message.endsWith("\n")) {
                System.err.print(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public static boolean isActive(IDebugLogConstants.DebugLogConstant client) {
        if (((Object)((Object)client)).equals((Object)IDebugLogConstants.PARSER)) {
            return VERBOSE_PARSER;
        }
        if (((Object)((Object)client)).equals((Object)IDebugLogConstants.SCANNER)) {
            return VERBOSE_SCANNER;
        }
        if (((Object)((Object)client)).equals((Object)IDebugLogConstants.MODEL)) {
            return VERBOSE_MODEL;
        }
        return false;
    }

    public static void setDebugging(boolean value) {
        CCorePlugin.getDefault().setDebugging(value);
    }

    public static int combineHashCodes(int hashCode1, int hashCode2) {
        return hashCode1 * 17 + hashCode2;
    }

    public static boolean equalArraysOrNull(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNull(int[] a, int[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalOrNull(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

