/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.xcoff.parser;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.ToolsProvider;
import org.eclipse.cdt.utils.xcoff.AR;
import org.eclipse.cdt.utils.xcoff.XCoff32;
import org.eclipse.cdt.utils.xcoff.parser.BinaryArchive;
import org.eclipse.cdt.utils.xcoff.parser.XCOFFBinaryObject;
import org.eclipse.core.runtime.IPath;

public class XCOFF32Parser
extends ToolsProvider
implements IBinaryParser {
    public IBinaryParser.IBinaryFile getBinary(byte[] hints, IPath path) throws IOException {
        if (path == null) {
            throw new IOException(CCorePlugin.getResourceString("Util.exception.nullPath"));
        }
        IBinaryParser.IBinaryFile binary = null;
        if (this.isBinary(hints, path)) {
            try {
                XCoff32.Attribute attribute = null;
                if (hints != null && hints.length > 0) {
                    try {
                        attribute = XCoff32.getAttributes(hints);
                    }
                    catch (EOFException eOFException) {}
                }
                if (attribute == null) {
                    attribute = XCoff32.getAttributes(path.toOSString());
                }
                if (attribute != null) {
                    switch (attribute.getType()) {
                        case 1: {
                            binary = this.createBinaryExecutable(path);
                            break;
                        }
                        case 2: {
                            binary = this.createBinaryShared(path);
                            break;
                        }
                        case 3: {
                            binary = this.createBinaryObject(path);
                            break;
                        }
                        case 4: {
                            binary = this.createBinaryCore(path);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                binary = this.createBinaryArchive(path);
            }
        }
        return binary;
    }

    public IBinaryParser.IBinaryFile getBinary(IPath path) throws IOException {
        return this.getBinary(null, path);
    }

    public String getFormat() {
        return "XCOFF32";
    }

    public boolean isBinary(byte[] hints, IPath path) {
        return XCoff32.isXCOFF32Header(hints) || AR.isARHeader(hints);
    }

    public int getHintBufferSize() {
        return 512;
    }

    private IBinaryParser.IBinaryFile createBinaryExecutable(IPath path) {
        return new XCOFFBinaryObject(this, path){

            public int getType() {
                return 2;
            }
        };
    }

    private IBinaryParser.IBinaryFile createBinaryShared(IPath path) {
        return new XCOFFBinaryObject(this, path){

            public int getType() {
                return 4;
            }
        };
    }

    private IBinaryParser.IBinaryFile createBinaryObject(IPath path) {
        return new XCOFFBinaryObject(this, path);
    }

    private IBinaryParser.IBinaryFile createBinaryCore(IPath path) {
        return new XCOFFBinaryObject(this, path){

            public int getType() {
                return 16;
            }
        };
    }

    private IBinaryParser.IBinaryFile createBinaryArchive(IPath path) throws IOException {
        return new BinaryArchive(this, path);
    }
}

