/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BaseCElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;

    public BaseCElementContentProvider() {
    }

    public BaseCElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this.fProvideMembers = provideMembers;
        this.fProvideWorkingCopy = provideWorkingCopy;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public void setProvideWorkingCopy(boolean b) {
        this.fProvideWorkingCopy = b;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (!this.exists(element)) {
            return NO_CHILDREN;
        }
        try {
            if (element instanceof ICModel) {
                return this.getCProjects((ICModel)element);
            }
            if (element instanceof ICProject) {
                return this.getSourceRoots((ICProject)element);
            }
            if (element instanceof ICContainer) {
                return this.getCResources((ICContainer)element);
            }
            if (element instanceof IBinaryContainer) {
                return NO_CHILDREN;
            }
            if (element instanceof IArchiveContainer) {
                return NO_CHILDREN;
            }
            if (element instanceof ITranslationUnit) {
                if (this.fProvideMembers) {
                    ITranslationUnit tu;
                    IWorkingCopy copy;
                    if (this.fProvideWorkingCopy && !(element instanceof IWorkingCopy) && (copy = (tu = (ITranslationUnit)element).findSharedWorkingCopy(CUIPlugin.getDefault().getBufferFactory())) != null) {
                        return copy.getChildren();
                    }
                    return ((IParent)element).getChildren();
                }
            } else {
                if (element instanceof IParent) {
                    return ((IParent)element).getChildren();
                }
                if (element instanceof IProject) {
                    return this.getResources((IProject)element);
                }
                if (element instanceof IFolder) {
                    return this.getResources((IFolder)element);
                }
            }
        }
        catch (CModelException cModelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object element) {
        if (this.fProvideMembers) {
            if (element instanceof IBinary || element instanceof ITranslationUnit || element instanceof IArchive) {
                return true;
            }
        } else if (element instanceof ITranslationUnit || element instanceof IBinary || element instanceof IArchive || element instanceof IFile) {
            return false;
        }
        if (element instanceof ICProject) {
            ICProject cp = (ICProject)element;
            return cp.getProject().isOpen();
        }
        if (element instanceof IBinaryContainer) {
            try {
                IBinaryContainer cont = (IBinaryContainer)element;
                IBinary[] bins = this.getExecutables(cont);
                return bins != null && bins.length > 0;
            }
            catch (CModelException cModelException) {
                return false;
            }
        }
        if (element instanceof IParent && ((IParent)element).hasChildren()) {
            return true;
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (!this.exists(element)) {
            return null;
        }
        return this.internalGetParent(element);
    }

    public Object internalGetParent(Object element) {
        IResource res;
        if (element instanceof IResource) {
            ICElement cParent;
            IContainer parent = ((IResource)element).getParent();
            if (parent != null && parent.isAccessible() && (cParent = CoreModel.getDefault().create((IResource)parent)) != null && cParent.exists()) {
                return cParent;
            }
            return parent;
        }
        Object parent = null;
        if (element instanceof ICElement) {
            parent = ((ICElement)element).getParent();
        }
        if (parent instanceof ISourceRoot) {
            if (this.isProjectSourceRoot((ISourceRoot)parent)) {
                parent = ((ISourceRoot)parent).getCProject();
            }
        } else if ((parent instanceof IBinaryContainer || parent instanceof IArchiveContainer) && element instanceof ICElement && (res = ((ICElement)element).getResource()) != null) {
            parent = this.internalGetParent(res);
        }
        return parent;
    }

    protected Object[] getCProjects(ICModel cModel) throws CModelException {
        Object[] objects = cModel.getCProjects();
        try {
            Object[] nonC = cModel.getNonCResources();
            if (nonC.length > 0) {
                objects = BaseCElementContentProvider.concatenate(objects, nonC);
            }
        }
        catch (CModelException cModelException) {}
        return objects;
    }

    protected Object[] getSourceRoots(ICProject cproject) throws CModelException {
        if (!cproject.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ISourceRoot[] roots = cproject.getSourceRoots();
        int i = 0;
        while (i < roots.length) {
            ISourceRoot root = roots[i];
            if (this.isProjectSourceRoot(root)) {
                ICElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    list.add(children[k]);
                    ++k;
                }
            } else {
                list.add(root);
            }
            ++i;
        }
        Object[] objects = list.toArray();
        Object[] nonC = cproject.getNonCResources();
        if (nonC != null && nonC.length > 0) {
            nonC = this.filterNonCResources(nonC, cproject);
            objects = BaseCElementContentProvider.concatenate(objects, nonC);
        }
        return objects;
    }

    protected Object[] getCResources(ICContainer container) throws CModelException {
        Object[] objects = null;
        Object[] children = container.getChildren();
        try {
            objects = container.getNonCResources();
            if (objects.length > 0) {
                objects = this.filterNonCResources(objects, container.getCProject());
            }
        }
        catch (CModelException cModelException) {}
        if (objects == null || objects.length == 0) {
            return children;
        }
        return BaseCElementContentProvider.concatenate(children, objects);
    }

    private Object[] getResources(IProject project) {
        try {
            return project.members();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private Object[] getResources(IFolder folder) throws CModelException {
        ICProject cproject = CoreModel.getDefault().create(folder.getProject());
        Object[] members = null;
        try {
            members = folder.members();
        }
        catch (CoreException coreException) {}
        if (members == null || members.length == 0) {
            return NO_CHILDREN;
        }
        return this.filterNonCResources(members, cproject);
    }

    private Object[] filterNonCResources(Object[] objects, ICProject cproject) throws CModelException {
        ICElement[] binaries = null;
        ICElement[] archives = null;
        try {
            binaries = this.getBinaries(cproject);
            archives = this.getArchives(cproject);
        }
        catch (CModelException cModelException) {
            archives = binaries = new ICElement[0];
        }
        ISourceRoot[] roots = null;
        try {
            roots = cproject.getSourceRoots();
        }
        catch (CModelException cModelException) {
            roots = new ISourceRoot[]{};
        }
        ArrayList<Object> nonCResources = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            block15: {
                Object o;
                block14: {
                    block13: {
                        o = objects[i];
                        if (!(o instanceof IFolder)) break block13;
                        IFolder folder = (IFolder)o;
                        boolean found = false;
                        int j = 0;
                        while (j < roots.length) {
                            if (roots[j].getPath().equals((Object)folder.getFullPath())) {
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) break block14;
                        break block15;
                    }
                    if (o instanceof IFile) {
                        boolean found = false;
                        int j = 0;
                        while (j < binaries.length) {
                            IResource res = binaries[j].getResource();
                            if (o.equals(res)) {
                                o = binaries[j];
                                found = true;
                                break;
                            }
                            ++j;
                        }
                        if (!found) {
                            j = 0;
                            while (j < archives.length) {
                                IResource res = archives[j].getResource();
                                if (o.equals(res)) {
                                    o = archives[j];
                                    break;
                                }
                                ++j;
                            }
                        }
                    }
                }
                nonCResources.add(o);
            }
            ++i;
        }
        return nonCResources.toArray();
    }

    protected boolean isProjectSourceRoot(ISourceRoot root) {
        IResource resource = root.getResource();
        return resource instanceof IProject;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof ICElement) {
            return ((ICElement)element).exists();
        }
        return true;
    }

    protected IBinary[] getExecutables(ICProject cproject) throws CModelException {
        IBinaryContainer container = cproject.getBinaryContainer();
        return this.getExecutables(container);
    }

    protected IBinary[] getExecutables(IBinaryContainer container) throws CModelException {
        ICElement[] celements = container.getChildren();
        ArrayList<IBinary> list = new ArrayList<IBinary>(celements.length);
        int i = 0;
        while (i < celements.length) {
            IBinary bin;
            if (celements[i] instanceof IBinary && ((bin = (IBinary)celements[i]).isExecutable() || bin.isSharedLib())) {
                list.add(bin);
            }
            ++i;
        }
        IBinary[] bins = new IBinary[list.size()];
        list.toArray(bins);
        return bins;
    }

    protected IBinary[] getBinaries(ICProject cproject) throws CModelException {
        IBinaryContainer container = cproject.getBinaryContainer();
        return this.getBinaries(container);
    }

    protected IBinary[] getBinaries(IBinaryContainer container) throws CModelException {
        ICElement[] celements = container.getChildren();
        ArrayList<IBinary> list = new ArrayList<IBinary>(celements.length);
        int i = 0;
        while (i < celements.length) {
            if (celements[i] instanceof IBinary) {
                IBinary bin = (IBinary)celements[i];
                list.add(bin);
            }
            ++i;
        }
        IBinary[] bins = new IBinary[list.size()];
        list.toArray(bins);
        return bins;
    }

    protected IArchive[] getArchives(ICProject cproject) throws CModelException {
        IArchiveContainer container = cproject.getArchiveContainer();
        return this.getArchives(container);
    }

    protected IArchive[] getArchives(IArchiveContainer container) throws CModelException {
        ICElement[] celements = container.getChildren();
        ArrayList<IArchive> list = new ArrayList<IArchive>(celements.length);
        int i = 0;
        while (i < celements.length) {
            if (celements[i] instanceof IArchive) {
                IArchive ar = (IArchive)celements[i];
                list.add(ar);
            }
            ++i;
        }
        IArchive[] ars = new IArchive[list.size()];
        list.toArray(ars);
        return ars;
    }

    protected static Object[] concatenate(Object[] a1, Object[] a2) {
        int a1Len = a1.length;
        int a2Len = a2.length;
        Object[] res = new Object[a1Len + a2Len];
        System.arraycopy(a1, 0, res, 0, a1Len);
        System.arraycopy(a2, 0, res, a1Len, a2Len);
        return res;
    }
}

