/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.Iterator;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.ide.IDEActionFactory;

public class OpenProjectGroup
extends CViewActionGroup {
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private RefreshAction refreshAction;
    static /* synthetic */ Class class$0;

    public OpenProjectGroup(CView cview) {
        super(cview);
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || isProjectSelection)) {
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable) {
                IResource res;
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((res = (IResource)iAdaptable.getAdapter((Class)clazz)) instanceof IProject) {
                    project = (IProject)res;
                }
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                continue;
            }
            hasClosedProjects = true;
        }
        if (!hasClosedProjects) {
            this.refreshAction.selectionChanged(selection);
            menu.add((IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.openProjectAction.selectionChanged(selection);
                menu.add((IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.closeProjectAction.selectionChanged(selection);
                menu.add((IAction)this.closeProjectAction);
            }
        }
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.keyCode == 0x100000E && event.stateMask == 0 && this.refreshAction.isEnabled()) {
            this.refreshAction.refreshAll();
        }
    }

    protected void makeActions() {
        Shell shell = this.getCView().getSite().getShell();
        IWorkspace workspace = CUIPlugin.getWorkspace();
        this.openProjectAction = new OpenResourceAction(shell);
        workspace.addResourceChangeListener((IResourceChangeListener)this.openProjectAction, 1);
        this.closeProjectAction = new CloseResourceAction(shell);
        workspace.addResourceChangeListener((IResourceChangeListener)this.closeProjectAction, 1);
        this.refreshAction = new RefreshAction(shell);
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/refresh_nav.gif"));
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("elcl16/refresh_nav.gif"));
        this.refreshAction.setHoverImageDescriptor(this.getImageDescriptor("clcl16/refresh_nav.gif"));
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(selection);
        this.openProjectAction.selectionChanged(selection);
        this.closeProjectAction.selectionChanged(selection);
    }

    public void dispose() {
        IWorkspace workspace = CUIPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.closeProjectAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.openProjectAction);
    }
}

