/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.codemanipulation.AddIncludeOperation;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class AddIncludeOnSelectionAction
extends Action
implements IUpdate {
    private ITextEditor fEditor;
    private IRequiredInclude[] fCachedRequiredIncludes;

    public AddIncludeOnSelectionAction() {
        this(null);
    }

    public AddIncludeOnSelectionAction(ITextEditor editor) {
        super(CEditorMessages.getString("AddIncludeOnSelection.label"));
        this.setToolTipText(CEditorMessages.getString("AddIncludeOnSelection.tooltip"));
        this.setDescription(CEditorMessages.getString("AddIncludeOnSelection.description"));
        this.fEditor = editor;
    }

    private void addInclude(IRequiredInclude[] inc, ITranslationUnit tu) {
        AddIncludeOperation op = new AddIncludeOperation(this.fEditor, tu, inc, false);
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message1"), (String)e.getTargetException().getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private ITranslationUnit getTranslationUnit() {
        IWorkingCopy unit = null;
        if (this.fEditor != null) {
            IEditorInput editorInput = this.fEditor.getEditorInput();
            unit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        }
        return unit;
    }

    protected Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    private int getNameStart(IDocument doc, int pos) throws BadLocationException {
        if (pos > 0 && doc.getChar(pos - 1) == '.') {
            --pos;
            while (pos > 0) {
                char ch = doc.getChar(pos - 1);
                if (!Character.isJavaIdentifierPart(ch) && ch != '.') {
                    return pos;
                }
                --pos;
            }
        }
        return pos;
    }

    public void run() {
        ITranslationUnit tu;
        IRequiredInclude[] requiredIncludes = this.fCachedRequiredIncludes != null ? this.fCachedRequiredIncludes : this.extractIncludes(this.fEditor);
        if (requiredIncludes != null && requiredIncludes.length > 0 && (tu = this.getTranslationUnit()) != null) {
            this.addInclude(requiredIncludes, tu);
        }
    }

    private IRequiredInclude[] extractIncludes(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        ISelection s = editor.getSelectionProvider().getSelection();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (s.isEmpty() || !(s instanceof ITextSelection) || doc == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)s;
        IRequiredInclude[] requiredIncludes = null;
        try {
            int selStart = selection.getOffset();
            int nameStart = this.getNameStart(doc, selStart);
            int len = selStart - nameStart + selection.getLength();
            String name = doc.get(nameStart, len).trim();
            IFunctionSummary fs = CCompletionContributorManager.getDefault().getFunctionInfo(name);
            if (fs != null) {
                requiredIncludes = fs.getIncludes();
            }
        }
        catch (BadLocationException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message3"), (String)(String.valueOf(CEditorMessages.getString("AddIncludeOnSelection.error.message4")) + e.getMessage()));
        }
        return requiredIncludes;
    }

    public void setContentEditor(ITextEditor editor) {
        this.fEditor = editor;
    }

    public void update() {
        this.fCachedRequiredIncludes = this.extractIncludes(this.fEditor);
        this.setEnabled(this.fCachedRequiredIncludes != null);
    }
}

