/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.IResolverModel;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CFileTypeDialog
extends Dialog {
    private Text fTextPattern;
    private Combo fComboType;
    private String fPattern;
    private ICFileType fType;

    public CFileTypeDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(PreferencesMessages.getString("CFileTypeDialog.title"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getOkayButton().setEnabled(this.getPatternFromControl().length() > 0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Label pattern = new Label(composite, 0);
        pattern.setText(PreferencesMessages.getString("CFileTypeDialog.patternLabel"));
        this.fTextPattern = new Text(composite, 2052);
        this.fTextPattern.setLayoutData((Object)new GridData(768));
        if (this.fPattern != null) {
            this.fTextPattern.setText(this.fPattern);
        }
        this.fTextPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CFileTypeDialog.this.getOkayButton().setEnabled(CFileTypeDialog.this.getPatternFromControl().length() > 0);
            }
        });
        Label type = new Label(composite, 0);
        type.setText(PreferencesMessages.getString("CFileTypeDialog.typeLabel"));
        this.fComboType = new Combo(composite, 12);
        this.fComboType.setLayoutData((Object)new GridData(768));
        this.populateTypesCombo();
        return composite;
    }

    public void setPattern(String pattern) {
        this.fPattern = pattern;
    }

    public String getPattern() {
        return this.fPattern;
    }

    public void setType(ICFileType type) {
        this.fType = type;
    }

    public ICFileType getType() {
        return this.fType;
    }

    private void populateTypesCombo() {
        ICFileType[] types = this.getResolverModel().getFileTypes();
        int index = -1;
        int i = 0;
        while (i < types.length) {
            this.fComboType.add(types[i].getName());
            ++i;
        }
        this.fComboType.setData((Object)types);
        if (this.fType != null) {
            index = this.fComboType.indexOf(this.fType.getName());
        }
        this.fComboType.select(index < 0 ? 0 : index);
    }

    private IResolverModel getResolverModel() {
        return CCorePlugin.getDefault().getResolverModel();
    }

    private Button getOkayButton() {
        return this.getButton(0);
    }

    private String getPatternFromControl() {
        return this.fTextPattern.getText().trim();
    }

    private ICFileType getTypeFromControl() {
        String typeId = null;
        int index = this.fComboType.getSelectionIndex();
        if (-1 != index) {
            String name = this.fComboType.getItem(index);
            ICFileType[] types = (ICFileType[])this.fComboType.getData();
            int i = 0;
            while (i < types.length) {
                if (name.equals(types[i].getName())) {
                    typeId = types[i].getId();
                }
                ++i;
            }
        }
        return this.getResolverModel().getFileTypeById(typeId);
    }

    protected void okPressed() {
        this.fPattern = this.getPatternFromControl();
        this.fType = this.getTypeFromControl();
        super.okPressed();
    }
}

