/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class CygpathTranslator {
    IProject project;
    private String orgPath;
    private String transPath;

    public CygpathTranslator(IProject project, String path) {
        this.project = project;
        this.orgPath = path;
    }

    public String run() {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void run() throws Exception {
                CygpathTranslator.this.transPath = CygpathTranslator.this.platformRun();
                if (CygpathTranslator.this.transPath.startsWith("cygpath:")) {
                    CygpathTranslator.this.transPath = null;
                }
            }

            public void handleException(Throwable exception) {
                CygpathTranslator.this.transPath = CygpathTranslator.this.orgPath;
                MakeCorePlugin.log(exception);
            }
        };
        Platform.run((ISafeRunnable)runnable);
        return this.transPath;
    }

    private String platformRun() {
        CommandLauncher launcher = new CommandLauncher();
        launcher.showCommand(false);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Process p = launcher.execute((IPath)new Path("cygpath"), new String[]{"-m", this.orgPath}, new String[0], this.project.getLocation());
        if (p != null) {
            try {
                p.getOutputStream().close();
            }
            catch (IOException iOException) {}
            if (launcher.waitAndRead((OutputStream)output, (OutputStream)output) == 0) {
                return ((Object)output).toString().trim();
            }
        }
        return this.orgPath;
    }

    private String[] setEnvironment(CommandLauncher launcher, String dir) {
        Path workingDirectory = new Path(dir);
        Properties props = launcher.getEnvironment();
        props.put("CWD", workingDirectory.toOSString());
        props.put("PWD", workingDirectory.toOSString());
        String[] env = null;
        ArrayList<String> envList = new ArrayList<String>();
        Enumeration<?> names = props.propertyNames();
        if (names != null) {
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                envList.add(String.valueOf(key) + "=" + props.getProperty(key));
            }
            env = envList.toArray(new String[envList.size()]);
        }
        return env;
    }
}

