/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.core.model.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.internal.core.model.CCoreFileDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CFormattedMemoryBlock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IProcess;

public class CDebugModel {
    public static String getPluginIdentifier() {
        return CDebugCorePlugin.getUniqueIdentifier();
    }

    public static IDebugTarget newDebugTarget(final ILaunch launch, final ICDITarget cdiTarget, final String name, final IProcess debuggeeProcess, final IProcess debuggerProcess, final IFile file, final boolean allowTerminate, final boolean allowDisconnect, boolean stopInMain) throws DebugException {
        final IDebugTarget[] target = new IDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) {
                target[0] = new CDebugTarget(launch, 1, cdiTarget, name, debuggeeProcess, debuggerProcess, file, allowTerminate, allowDisconnect);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
            throw new DebugException(e.getStatus());
        }
        ICDIConfiguration config = cdiTarget.getSession().getConfiguration();
        if (config.supportsBreakpoints() && stopInMain) {
            CDebugModel.stopInMain((CDebugTarget)target[0]);
        }
        if (config.supportsResume()) {
            target[0].resume();
        }
        return target[0];
    }

    public static IDebugTarget newAttachDebugTarget(final ILaunch launch, final ICDITarget cdiTarget, final String name, final IProcess debuggerProcess, final IFile file) throws DebugException {
        final IDebugTarget[] target = new IDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) {
                target[0] = new CDebugTarget(launch, 2, cdiTarget, name, null, debuggerProcess, file, false, true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
            throw new DebugException(e.getStatus());
        }
        ICDIEvent[] events = new ICDIEvent[]{new ICDISuspendedEvent(){

            public ICDISessionObject getReason() {
                return null;
            }

            public ICDIObject getSource() {
                return cdiTarget;
            }
        }};
        ((CDebugTarget)target[0]).handleDebugEvents(events);
        return target[0];
    }

    public static IDebugTarget newCoreFileDebugTarget(final ILaunch launch, final ICDITarget cdiTarget, final String name, final IProcess debuggerProcess, final IFile file) throws DebugException {
        final IDebugTarget[] target = new IDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) {
                target[0] = new CCoreFileDebugTarget(launch, cdiTarget, name, debuggerProcess, file);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
            throw new DebugException(e.getStatus());
        }
        ICDIEvent[] events = new ICDIEvent[]{new ICDISuspendedEvent(){

            public ICDISessionObject getReason() {
                return null;
            }

            public ICDIObject getSource() {
                return cdiTarget;
            }
        }};
        ((CDebugTarget)target[0]).handleDebugEvents(events);
        return target[0];
    }

    public static IExpression createExpression(IDebugTarget target, String text) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression cdiExpression = ((CDebugTarget)target).getCDISession().getExpressionManager().createExpression(text);
                return new CExpression((CDebugTarget)target, cdiExpression);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, e.getMessage(), null));
            }
        }
        return null;
    }

    public static IExpression createExpressionForGlobalVariable(IDebugTarget target, IPath fileName, String name) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            ICDIVariableObject vo = null;
            try {
                vo = ((CDebugTarget)target).getCDISession().getVariableManager().getGlobalVariableObject(fileName.lastSegment(), null, name);
                ICDIVariable cdiVariable = ((CDebugTarget)target).getCDISession().getVariableManager().createVariable(vo);
                return new CExpression((CDebugTarget)target, (ICDIVariableObject)cdiVariable);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, vo != null ? String.valueOf(vo.getName()) + ": " + e.getMessage() : e.getMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget target, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns, char paddingChar) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression expression = ((CDebugTarget)target).getCDISession().getExpressionManager().createExpression(addressExpression);
                ICDIMemoryBlock cdiMemoryBlock = ((CDebugTarget)target).getCDISession().getMemoryManager().createMemoryBlock(expression.getName(), wordSize * numberOfRows * numberOfColumns);
                return new CFormattedMemoryBlock((CDebugTarget)target, cdiMemoryBlock, expression, format, wordSize, numberOfRows, numberOfColumns, paddingChar);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, e.getDetailMessage(), null));
            }
        }
        return null;
    }

    public static IFormattedMemoryBlock createFormattedMemoryBlock(IDebugTarget target, String addressExpression, int format, int wordSize, int numberOfRows, int numberOfColumns) throws DebugException {
        if (target != null && target instanceof CDebugTarget) {
            try {
                ICDIExpression expression = ((CDebugTarget)target).getCDISession().getExpressionManager().createExpression(addressExpression);
                ICDIMemoryBlock cdiMemoryBlock = ((CDebugTarget)target).getCDISession().getMemoryManager().createMemoryBlock(expression.getName(), wordSize * numberOfRows * numberOfColumns);
                return new CFormattedMemoryBlock((CDebugTarget)target, cdiMemoryBlock, expression, format, wordSize, numberOfRows, numberOfColumns);
            }
            catch (CDIException e) {
                throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 5010, e.getDetailMessage(), null));
            }
        }
        return null;
    }

    private static void stopInMain(CDebugTarget target) throws DebugException {
        block2: {
            ICDILocation location = target.getCDISession().getBreakpointManager().createLocation("", "main", 0);
            try {
                target.setInternalTemporaryBreakpoint(location);
            }
            catch (DebugException e) {
                String message = MessageFormat.format(DebugCoreMessages.getString("CDebugModel.0"), e.getStatus().getMessage());
                Status newStatus = new Status(2, e.getStatus().getPlugin(), 10000, message, null);
                if (CDebugUtils.question((IStatus)newStatus, target)) break block2;
                target.terminate();
                throw new DebugException((IStatus)new Status(0, e.getStatus().getPlugin(), e.getStatus().getCode(), e.getStatus().getMessage(), null));
            }
        }
    }
}

