/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.filetype;

import org.eclipse.cdt.core.filetype.ICFileType;
import org.eclipse.cdt.core.filetype.ICFileTypeAssociation;
import org.eclipse.cdt.core.filetype.ICLanguage;
import org.eclipse.core.resources.IProject;

public class ResolverDelta {
    public static final int EVENT_ADD = 16;
    public static final int EVENT_REMOVE = 32;
    public static final int EVENT_SET = 64;
    public static final int EVENT_MASK = 240;
    public static final int ELEMENT_LANGUAGE = 1;
    public static final int ELEMENT_FILETYPE = 2;
    public static final int ELEMENT_ASSOCIATION = 4;
    public static final int ELEMENT_PROJECT = 8;
    public static final int ELEMENT_WORKSPACE = 15;
    public static final int ELEMENT_MASK = 15;
    private Object fElement;
    private int fEvent;

    public ResolverDelta(int event, int source, Object element) {
        this.fElement = element;
        this.fEvent = event | source;
    }

    public ResolverDelta(ICLanguage lang, int event) {
        this(event, 1, lang);
    }

    public ResolverDelta(ICFileType type, int event) {
        this(event, 2, type);
    }

    public ResolverDelta(ICFileTypeAssociation assoc, int event) {
        this(event, 4, assoc);
    }

    public Object getElement() {
        return this.fElement;
    }

    public int getElementType() {
        return this.fEvent & 0xF;
    }

    public int getEventType() {
        return this.fEvent & 0xF0;
    }

    public ICLanguage getLanguage() {
        return this.fElement instanceof ICLanguage ? (ICLanguage)this.fElement : null;
    }

    public ICFileType getFileType() {
        return this.fElement instanceof ICFileType ? (ICFileType)this.fElement : null;
    }

    public ICFileTypeAssociation getAssociation() {
        return this.fElement instanceof ICFileTypeAssociation ? (ICFileTypeAssociation)this.fElement : null;
    }

    public IProject getProject() {
        return this.fElement instanceof IProject ? (IProject)this.fElement : null;
    }

    public int getEvent() {
        return this.fEvent;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.getEventType()) {
            case 16: {
                buf.append("add");
                break;
            }
            case 32: {
                buf.append("remove");
                break;
            }
            case 64: {
                buf.append("set");
                break;
            }
            default: {
                buf.append("?unknown event?");
            }
        }
        buf.append(" ");
        switch (this.getElementType()) {
            case 1: {
                buf.append("language ");
                buf.append(this.getLanguage() != null ? this.getLanguage().getName() : "?");
                break;
            }
            case 2: {
                buf.append("filetype ");
                buf.append(this.getFileType() != null ? this.getFileType().getName() : "?");
                break;
            }
            case 4: {
                buf.append("assoc ");
                buf.append(this.getAssociation() != null ? this.getAssociation().getPattern() : "?");
                break;
            }
            case 8: {
                buf.append("resolver for project ");
                buf.append(this.getProject() != null ? this.getProject().getName() : "?");
                break;
            }
            case 15: {
                buf.append("resolver for workspace");
                break;
            }
            default: {
                buf.append("?unknown source?");
            }
        }
        return buf.toString();
    }
}

