/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsole;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleStream;
import org.eclipse.cdt.internal.ui.buildconsole.ConsoleEvent;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IBuildConsoleListener;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleView;

public class BuildConsoleManager
implements IBuildConsoleManager,
IResourceChangeListener,
IPropertyChangeListener {
    ListenerList listeners = new ListenerList(1);
    BuildConsole fConsole;
    private Map fConsoleMap = new HashMap();
    private Color infoColor;
    private Color outputColor;
    private Color errorColor;
    private BuildConsoleStream infoStream;
    private BuildConsoleStream outputStream;
    private BuildConsoleStream errorStream;
    public static final int BUILD_STREAM_TYPE_INFO = 0;
    public static final int BUILD_STREAM_TYPE_OUTPUT = 1;
    public static final int BUILD_STREAM_TYPE_ERROR = 2;

    protected void startConsoleActivity(IProject project) {
        Object[] list = this.listeners.getListeners();
        if (list.length > 0) {
            int i = 0;
            while (i < list.length) {
                IBuildConsoleListener listener = (IBuildConsoleListener)list[i];
                ConsoleEvent event = new ConsoleEvent(this, project, 1);
                listener.consoleChange(event);
                ++i;
            }
        }
        this.showConsole();
    }

    protected void showConsole() {
        CUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window = CUIPlugin.getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    IViewPart consoleView = page.findView("org.eclipse.ui.console.ConsoleView");
                    if (consoleView == null && BuildConsolePreferencePage.isAutoOpenConsole()) {
                        IWorkbenchPart activePart = page.getActivePart();
                        try {
                            consoleView = page.showView("org.eclipse.ui.console.ConsoleView");
                        }
                        catch (PartInitException pie) {
                            CUIPlugin.getDefault().log(pie);
                        }
                        page.activate(activePart);
                    } else {
                        boolean bringToTop = BuildConsoleManager.this.shouldBringToTop(consoleView);
                        if (bringToTop) {
                            page.bringToTop((IWorkbenchPart)consoleView);
                        }
                    }
                    if (consoleView instanceof IConsoleView) {
                        ((IConsoleView)consoleView).display((org.eclipse.ui.console.IConsole)BuildConsoleManager.this.fConsole);
                    }
                }
            }
        });
    }

    boolean shouldBringToTop(IViewPart consoleView) {
        boolean bringToTop = false;
        if (consoleView instanceof IConsoleView) {
            IConsoleView cView = (IConsoleView)consoleView;
            return !cView.isPinned() && BuildConsolePreferencePage.isConsoleOnTop();
        }
        return bringToTop;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IDocumentPartitioner partioner;
        IResource resource = event.getResource();
        if (resource != null && resource.getType() == 4 && (event.getType() == 4 || event.getType() == 2) && (partioner = (IDocumentPartitioner)this.fConsoleMap.remove(resource)) != null) {
            partioner.disconnect();
            Object[] list = this.listeners.getListeners();
            if (list.length > 0) {
                int i = 0;
                while (i < list.length) {
                    IBuildConsoleListener listener = (IBuildConsoleListener)list[i];
                    ConsoleEvent consoleEvent = new ConsoleEvent(this, (IProject)resource, 2);
                    listener.consoleChange(consoleEvent);
                    ++i;
                }
            }
        }
    }

    public void shutdown() {
        if (this.infoColor != null) {
            this.infoColor.dispose();
            this.outputColor.dispose();
            this.errorColor.dispose();
        }
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new org.eclipse.ui.console.IConsole[]{this.fConsole});
        CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void runUI(Runnable run) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
            display.asyncExec(run);
        } else {
            run.run();
        }
    }

    public void startup() {
        this.infoStream = new BuildConsoleStream();
        this.outputStream = new BuildConsoleStream();
        this.errorStream = new BuildConsoleStream();
        this.runUI(new Runnable(){

            public void run() {
                BuildConsoleManager.this.fConsole = new BuildConsole(BuildConsoleManager.this);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new org.eclipse.ui.console.IConsole[]{BuildConsoleManager.this.fConsole});
                BuildConsoleManager.this.infoStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.infoColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleInfoStreamColor");
                BuildConsoleManager.this.infoStream.setColor(BuildConsoleManager.this.infoColor);
                BuildConsoleManager.this.outputStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.outputColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleOutputStreamColor");
                BuildConsoleManager.this.outputStream.setColor(BuildConsoleManager.this.outputColor);
                BuildConsoleManager.this.errorStream.setConsole(BuildConsoleManager.this.fConsole);
                BuildConsoleManager.this.errorColor = BuildConsoleManager.this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleErrorStreamColor");
                BuildConsoleManager.this.errorStream.setColor(BuildConsoleManager.this.errorColor);
            }
        });
        CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("buildConsoleInfoStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleInfoStreamColor");
            this.infoStream.setColor(newColor);
            this.infoColor.dispose();
            this.infoColor = newColor;
        } else if (property.equals("buildConsoleOutputStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleOutputStreamColor");
            this.outputStream.setColor(newColor);
            this.outputColor.dispose();
            this.outputColor = newColor;
        } else if (property.equals("buildConsoleErrorStreamColor")) {
            Color newColor = this.createColor(CUIPlugin.getStandardDisplay(), "buildConsoleErrorStreamColor");
            this.errorStream.setColor(newColor);
            this.errorColor.dispose();
            this.errorColor = newColor;
        }
    }

    public BuildConsoleStream getStream(int type) throws CoreException {
        switch (type) {
            case 2: {
                return this.errorStream;
            }
            case 0: {
                return this.infoStream;
            }
            case 1: {
                return this.outputStream;
            }
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", -1, "No Such Console", null));
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)CUIPlugin.getDefault().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    public IConsole getConsole(IProject project) {
        Assert.isNotNull((Object)project);
        return this.getConsolePartioner(project).getConsole();
    }

    private BuildConsolePartitioner getConsolePartioner(IProject project) {
        BuildConsolePartitioner partioner = (BuildConsolePartitioner)this.fConsoleMap.get(project);
        if (partioner == null) {
            partioner = new BuildConsolePartitioner(this);
            this.fConsoleMap.put(project, partioner);
        }
        return partioner;
    }

    public IDocument getConsoleDocument(IProject project) {
        Assert.isNotNull((Object)project);
        return this.getConsolePartioner(project).getDocument();
    }

    public void addConsoleListener(IBuildConsoleListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeConsoleListener(IBuildConsoleListener listener) {
        this.listeners.remove((Object)listener);
    }
}

