/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.actions.FindDeclarationsAction;
import org.eclipse.cdt.internal.ui.search.actions.FindDeclarationsInWorkingSetAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class DeclarationsSearchGroup
extends ActionGroup {
    private CEditor fEditor;
    private FindDeclarationsAction fFindDeclarationsAction;
    private FindDeclarationsInWorkingSetAction fFindDeclarationsInWorkingSetAction;

    public DeclarationsSearchGroup(IWorkbenchSite site) {
        this.fFindDeclarationsAction = new FindDeclarationsAction(site);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(site);
    }

    public DeclarationsSearchGroup(CEditor editor) {
        this.fEditor = editor;
        this.fFindDeclarationsAction = new FindDeclarationsAction(editor);
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.cdt.ui.search.finddecl");
        if (editor != null) {
            editor.setAction("org.eclipse.cdt.ui.search.finddecl", (IAction)this.fFindDeclarationsAction);
        }
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(editor);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IMenuManager incomingMenu = menu;
        MenuManager declarationsMenu = new MenuManager(CSearchMessages.getString("group.declarations"), "group.search");
        if (this.fEditor != null) {
            menu.appendToGroup("group.find", (IContributionItem)declarationsMenu);
        }
        incomingMenu.add((IContributionItem)declarationsMenu);
        incomingMenu = declarationsMenu;
        incomingMenu.add((IAction)this.fFindDeclarationsAction);
        incomingMenu.add((IAction)this.fFindDeclarationsInWorkingSetAction);
    }

    public static boolean canActionBeAdded(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() > 0;
        }
        return DeclarationsSearchGroup.getElement(selection) != null;
    }

    private static ICElement getElement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }

    public void dispose() {
        this.fFindDeclarationsAction = null;
        this.fFindDeclarationsInWorkingSetAction = null;
        super.dispose();
    }
}

