/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectOptionPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectWizard;
import org.eclipse.cdt.ui.dialogs.AbstractErrorParserBlock;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ErrorParserBlock
extends AbstractErrorParserBlock {
    public ErrorParserBlock() {
        super(null);
    }

    protected String[] getErrorParserIDs(ITarget target) {
        String[] errorParsers = target.getErrorParserList();
        if (errorParsers != null) {
            return errorParsers;
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    protected String[] getErrorParserIDs(IProject project) {
        ITarget target = ManagedBuildManager.getSelectedTarget((IProject)project);
        if (target == null) {
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
            target = info.getDefaultTarget();
        }
        if (target != null) {
            return this.getErrorParserIDs(target);
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    protected String[] getErrorParserIDs() {
        ICOptionContainer container = this.getContainer();
        if (container instanceof NewManagedProjectOptionPage) {
            NewManagedProjectOptionPage parent = (NewManagedProjectOptionPage)this.getContainer();
            NewManagedProjectWizard wizard = (NewManagedProjectWizard)parent.getWizard();
            ITarget target = wizard.getSelectedTarget();
            return this.getErrorParserIDs(target);
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    public void saveErrorParsers(IProject project, String[] parsers) {
        ITarget target = ManagedBuildManager.getSelectedTarget((IProject)project);
        if (target != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < parsers.length) {
                if (i > 0) {
                    buf.append(';');
                }
                buf.append(parsers[i]);
                ++i;
            }
            target.setErrorParserIds(buf.toString());
        }
    }
}

