/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.SignalPropertiesDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionDelegate;

public class SignalPropertiesActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private ICSignal fSignal;
    private SignalPropertiesDialog fDialog;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof ICSignal) {
            action.setEnabled(true);
            this.setSignal((ICSignal)element);
            return;
        }
        action.setEnabled(false);
        this.setSignal(null);
    }

    protected ICSignal getSignal() {
        return this.fSignal;
    }

    private void setSignal(ICSignal signal) {
        this.fSignal = signal;
    }

    public void run(IAction action) {
        if (this.getSignal() != null) {
            final MultiStatus ms = new MultiStatus(CDebugUIPlugin.getUniqueIdentifier(), 5012, ActionMessages.getString("SignalPropertiesActionDelegate.Unable_to_change_signal_properties_1"), null);
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        SignalPropertiesActionDelegate.this.doAction(SignalPropertiesActionDelegate.this.getSignal());
                    }
                    catch (DebugException e) {
                        ms.merge(e.getStatus());
                    }
                }
            });
            if (!ms.isOK()) {
                IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    CDebugUIPlugin.errorDialog(ActionMessages.getString("SignalPropertiesActionDelegate.Operation_failed_1"), (IStatus)ms);
                } else {
                    CDebugUIPlugin.log((IStatus)ms);
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doAction(ICSignal signal) throws DebugException {
        IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Shell activeShell = window.getShell();
        if (this.fDialog != null) {
            return;
        }
        String name = signal.getName();
        String description = signal.getDescription();
        boolean pass = signal.isPassEnabled();
        boolean stop = signal.isStopEnabled();
        boolean canModify = signal.canModify();
        this.fDialog = new SignalPropertiesDialog(activeShell, name, description, pass, stop, canModify);
        try {
            if (this.fDialog.open() == 0) {
                this.setProperties(signal, this.fDialog.isPassEnabled(), this.fDialog.isStopEnabled());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.fDialog = null;
            throw throwable;
        }
        {
            Object var10_12 = null;
            this.fDialog = null;
            return;
        }
    }

    private void setProperties(ICSignal signal, boolean pass, boolean stop) throws DebugException {
        signal.setPassEnabled(pass);
        signal.setStopEnabled(stop);
    }
}

