/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterObject;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegister;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegisterGroup
extends CDebugElement
implements IRegisterGroup {
    private String fName;
    private ICDIRegisterObject[] fRegisterObjects;
    private IRegister[] fRegisters;

    public CRegisterGroup(CDebugTarget target, String name, ICDIRegisterObject[] regObjects) {
        super(target);
        this.fName = name;
        this.fRegisterObjects = regObjects;
        this.fRegisters = new IRegister[regObjects.length];
    }

    public String getName() throws DebugException {
        return this.fName;
    }

    public IRegister[] getRegisters() throws DebugException {
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] == null) {
                this.fRegisters[i] = new CRegister(this, this.getCDIRegister(this.fRegisterObjects[i]));
            }
            ++i;
        }
        return this.fRegisters;
    }

    public boolean hasRegisters() throws DebugException {
        return this.fRegisterObjects.length > 0;
    }

    public void dispose() {
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null) {
                ((CRegister)this.fRegisters[i]).dispose();
                this.fRegisters[i] = null;
            }
            ++i;
        }
    }

    private ICDIRegister getCDIRegister(ICDIRegisterObject ro) throws DebugException {
        try {
            return ((CDebugTarget)this.getDebugTarget()).getCDISession().getRegisterManager().createRegister(ro);
        }
        catch (CDIException e) {
            return new CRegister.ErrorRegister(ro, e);
        }
    }

    public void resetChangeFlags() {
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null) {
                try {
                    ((CRegister)this.fRegisters[i]).setChanged(false);
                }
                catch (DebugException e) {
                    DebugPlugin.log((Throwable)e);
                }
            }
            ++i;
        }
    }

    public void targetSuspended() {
        int i = 0;
        while (i < this.fRegisters.length) {
            if (this.fRegisters[i] != null && ((CRegister)this.fRegisters[i]).hasErrors()) {
                ((CRegister)this.fRegisters[i]).dispose();
                this.fRegisters[i] = null;
            }
            ++i;
        }
    }
}

