/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.codegen/src/org/eclipse/emf/codegen/CodeGenPlugin.java, emf.codegen, org.eclipse.102, 20030326_0335VL
 * @version 1.3 3/26/03
 */
package org.eclipse.emf.codegen;


import java.text.MessageFormat;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;


/**
 * This is the central singleton for the emf.codegen plugin.
 */
public class CodeGenPlugin extends Plugin
{
  // public static final String JET_BUILDER_ID = "org.eclipse.emf.codegen.JETBuilder";

  /**
   * Get the singleton instance.
   */
  public static CodeGenPlugin getPlugin()
  {
    return plugin;
  }

  /**
   * This keeps track of the one instance of this class.
   */
  private static CodeGenPlugin plugin;

  /**
   * Create the instance.
   */
  public CodeGenPlugin(IPluginDescriptor descriptor)
  {
    super(descriptor);

    // Remember the static instance.
    //
    plugin = this;
  }

  /**
   * This fetches a resource string from the plugin.properites file.
   */
  public String getString(String key)
  {
    return plugin.getDescriptor().getResourceBundle().getString(key);
  }

  /**
   * This fetches a resource string from the plugin.properites file and performs message substitution.
   */
  public String getString(String key, Object [] objects)
  {
    return MessageFormat.format(getString(key), objects);
  }

  public static void write(Exception exception)
  {
    exception.printStackTrace();
  }
}
