/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.codegen.ecore/src/org/eclipse/emf/codegen/ecore/genmodel/impl/GenEnumLiteralImpl.java, emf.codegen.ecore, org.eclipse.102, 20030326_0335VL
 * @version 1.34 3/26/03
 */
package org.eclipse.emf.codegen.ecore.genmodel.impl;


import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnumLiteral;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.NotificationChainImpl;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Gen Enum Literal</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.codegen.ecore.genmodel.impl.GenEnumLiteralImpl#getGenEnum <em>Gen Enum</em>}</li>
 *   <li>{@link org.eclipse.emf.codegen.ecore.genmodel.impl.GenEnumLiteralImpl#getEcoreEnumLiteral <em>Ecore Enum Literal</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class GenEnumLiteralImpl extends GenBaseImpl implements GenEnumLiteral
{
  /**
   * The cached value of the '{@link #getEcoreEnumLiteral() <em>Ecore Enum Literal</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getEcoreEnumLiteral()
   * @generated
   * @ordered
   */
  protected EEnumLiteral ecoreEnumLiteral = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated modifiable
   */
  protected GenEnumLiteralImpl() 
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EClass eStaticClass()
  {
    return GenModelPackage.eINSTANCE.getGenEnumLiteral();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public GenEnum getGenEnum()
  {
    if (eContainerFeatureID != GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM) return null;
    return (GenEnum)eContainer;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setGenEnum(GenEnum newGenEnum)
  {
    if (newGenEnum != eContainer || (eContainerFeatureID != GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM && newGenEnum != null))
    {
      if (EcoreUtil.isAncestor(this, newGenEnum))
        throw new IllegalArgumentException("Recursive containment not allowed for " + toString() + ".");
      NotificationChain msgs = null;
      if (eContainer != null)
        msgs = eBasicRemoveFromContainer(msgs);
      if (newGenEnum != null)
        msgs = ((InternalEObject)newGenEnum).eInverseAdd(this, GenModelPackage.GEN_ENUM__GEN_ENUM_LITERALS, GenEnum.class, msgs);
      msgs = eBasicSetContainer((InternalEObject)newGenEnum, GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM, msgs);
      if (msgs != null) msgs.dispatch();
    }
    else if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM, newGenEnum, newGenEnum));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EEnumLiteral getEcoreEnumLiteral()
  {
    if (ecoreEnumLiteral != null && ecoreEnumLiteral.eIsProxy())
    {
      EEnumLiteral oldEcoreEnumLiteral = ecoreEnumLiteral;
      ecoreEnumLiteral = (EEnumLiteral)EcoreUtil.resolve(ecoreEnumLiteral, this);
      if (ecoreEnumLiteral != oldEcoreEnumLiteral)
      {
        if (eNotificationRequired())
          eNotify(new ENotificationImpl(this, Notification.RESOLVE, GenModelPackage.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL, oldEcoreEnumLiteral, ecoreEnumLiteral));
      }
    }
    return ecoreEnumLiteral;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EEnumLiteral basicGetEcoreEnumLiteral()
  {
    return ecoreEnumLiteral;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setEcoreEnumLiteral(EEnumLiteral newEcoreEnumLiteral)
  {
    EEnumLiteral oldEcoreEnumLiteral = ecoreEnumLiteral;
    ecoreEnumLiteral = newEcoreEnumLiteral;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, GenModelPackage.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL, oldEcoreEnumLiteral, ecoreEnumLiteral));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      switch (eDerivedStructuralFeatureID(featureID, baseClass))
      {
        case GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM:
          if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
          return eBasicSetContainer(otherEnd, GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM, msgs);
        default:
          return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
      }
    }
    if (eContainer != null)
      msgs = eBasicRemoveFromContainer(msgs);
    return eBasicSetContainer(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      switch (baseClass == null ? featureID : eDerivedStructuralFeatureID(featureID, baseClass))
      {
        case GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM:
          return eBasicSetContainer(null, GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM, msgs);
        default:
          return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
      }
    }
    return eBasicSetContainer(null, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
  {
    if (eContainerFeatureID >= 0)
    {
      switch (eContainerFeatureID)
      {
        case GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM:
          return ((InternalEObject)eContainer).eInverseRemove(this, GenModelPackage.GEN_ENUM__GEN_ENUM_LITERALS, GenEnum.class, msgs);
        default:
          return eDynamicBasicRemoveFromContainer(msgs);
      }
    }
    return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object eGet(EStructuralFeature eFeature, boolean resolve)
  {
    switch (eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass()))
    {
      case GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM:
        return getGenEnum();
      case GenModelPackage.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL:
        if (resolve) return getEcoreEnumLiteral();
        return basicGetEcoreEnumLiteral();
    }
    return eDynamicGet(eFeature, resolve);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean eIsSet(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass()))
    {
      case GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM:
        return getGenEnum() != null;
      case GenModelPackage.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL:
        return ecoreEnumLiteral != null;
    }
    return eDynamicIsSet(eFeature);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eSet(EStructuralFeature eFeature, Object newValue)
  {
    switch (eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass()))
    {
      case GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM:
        setGenEnum((GenEnum)newValue);
        return;
      case GenModelPackage.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL:
        setEcoreEnumLiteral((EEnumLiteral)newValue);
        return;
    }
    eDynamicSet(eFeature, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eUnset(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature.getFeatureID(), eFeature.getContainerClass()))
    {
      case GenModelPackage.GEN_ENUM_LITERAL__GEN_ENUM:
        setGenEnum((GenEnum)null);
        return;
      case GenModelPackage.GEN_ENUM_LITERAL__ECORE_ENUM_LITERAL:
        setEcoreEnumLiteral((EEnumLiteral)null);
        return;
    }
    eDynamicUnset(eFeature);
  }

  public String getName()
  {
    return getEcoreEnumLiteral().getName();
  }

  public String getCapName()
  {
    return capName(getName());
  }

  public String getFormattedName()
  {
    return format(getCapName(), ' ', null, false);
  }

  public int getValue()
  {
    return getEcoreEnumLiteral().getValue();
  }

  public String getEnumLiteralID()
  {
    return format(getName(), '_', null, false).toUpperCase();
  }

  public GenPackage getGenPackage()
  {
    return getGenEnum().getGenPackage();
  }

  public String getEnumLiteralAccessorName()
  {
    return getGenEnum().getName() + "_" + getCapName();
  }

  public void initialize(EEnumLiteral eEnumLiteral)
  {
    setEcoreEnumLiteral(eEnumLiteral);
  }

  public String getModelInfo()
  {
    if (!getEnumLiteralID().equals(getName()))
    {
      return "name=\"" + getName()+ "\"";
    }
    else
    {
      return "";
    }
  }

  public boolean reconcile(GenEnumLiteral oldGenEnumLiteralVersion)
  {
    if (getEcoreEnumLiteral().getName().equals(oldGenEnumLiteralVersion.getEcoreEnumLiteral().getName()))
    {
      reconcileSettings(oldGenEnumLiteralVersion);
      return true;
    }
    else
    {
      return false;
    }
  }

  protected void reconcileSettings(GenEnumLiteral oldGenEnumLiteralVersion)
  {
  }

  public boolean reconcile()
  {
    EEnumLiteral eEnumLiteral = getEcoreEnumLiteral();
    if (eEnumLiteral == null || eEnumLiteral.eIsProxy() || eEnumLiteral.eResource() == null)
    {
      return false;
    }
    else
    {
      return true;
    }
  }

}
