/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/impl/EPackageRegistryImpl.java, emf.ecore, org.eclipse.102, 20030326_0335VL
 * @version 1.18 3/26/03
 */
package org.eclipse.emf.ecore.impl;


import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.emf.common.util.WrappedException;

import org.eclipse.emf.ecore.EPackage;


/**
 * An implementation of a package registry.
 */
public class EPackageRegistryImpl extends HashMap implements EPackage.Registry
{
  public EPackageRegistryImpl()
  {
  }

  public EPackage getEPackage(String nsURI)
  {
    Object ePackage = get(nsURI);
    if (ePackage instanceof EPackage)
    {
      EPackage result = (EPackage)ePackage;
      if (result.getNsURI() == null)
      {
        initialize(result);
      }
      return result;
    }
    else if (ePackage instanceof EPackage.Descriptor)
    {
      EPackage.Descriptor ePackageDescriptor = (EPackage.Descriptor)ePackage;
      EPackage result = ePackageDescriptor.getEPackage();
      put(nsURI, result);
      initialize(result);
      return result;
    }
    else
    {
      return delegatedGetEPackage(nsURI);
    }
  }

  protected void initialize(EPackage ePackage)
  {
/*
    // Try to invoke init method to initialize prerequisite packages
    //
    try
    {
      Method initMethod = ePackage.getClass().getMethod("init", null);
      initMethod.invoke(null, null);
    }
    catch (NoSuchMethodException e)
    {
       throw new WrappedException(e);
    }
    catch (IllegalAccessException e)
    {
       throw new WrappedException(e);
    }
    catch (InvocationTargetException e)
    {
      throw new WrappedException(e);
    }
*/
  }

  public EPackage delegatedGetEPackage(String nsURI)
  {
    return null;
  }
}
