/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/util/EObjectWithInverseEList.java, emf.ecore, org.eclipse.102, 20030326_0335VL
 * @version 1.9 3/26/03
 */
package org.eclipse.emf.ecore.util;


import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.InternalEObject;


public class EObjectWithInverseEList extends EObjectEList 
{
  public static class Unsettable extends EObjectWithInverseEList
  {
    public static class ManyInverse extends Unsettable
    {
      public ManyInverse(Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID)
      {
        super(dataClass, owner, featureID, inverseFeatureID);
      }

      protected boolean hasManyInverse()
      {
        return true;
      }
    }

    protected boolean isSet;

    public Unsettable(Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID)
    {
      super(dataClass, owner, featureID, inverseFeatureID);
    }

    protected void didChange()
    {
      isSet = true;
    }

    public boolean isSet()
    {
      return isSet;
    }

    public void unset()
    {
      super.unset();
      if (isNotificationRequired())
      {
        boolean oldIsSet = isSet;
        isSet = false;
        owner.eNotify(createNotification(Notification.UNSET, oldIsSet, false));
      }
      else
      {
        isSet = false;
      }
    }
  }

  public static class ManyInverse extends EObjectWithInverseEList
  {
    public ManyInverse(Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID)
    {
      super(dataClass, owner, featureID, inverseFeatureID);
    }

    protected boolean hasManyInverse()
    {
      return true;
    }
  }

  protected int inverseFeatureID;

  public EObjectWithInverseEList
    (Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID)
  {
    super(dataClass, owner, featureID);
    this.inverseFeatureID = inverseFeatureID;
  }

  protected boolean hasInverse()
  {
    return true;
  }

  protected boolean hasNavigableInverse()
  {
    return true;
  }

  public int getInverseFeatureID()
  {
    return inverseFeatureID;
  }
  
  public Class getInverseFeatureClass()
  {
    return dataClass;
  }
}
