/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/util/EcoreEList.java, emf.ecore, org.eclipse.102, 20030326_0335VL
 * @version 1.36 3/26/03
 */
package org.eclipse.emf.ecore.util;


import java.lang.reflect.Array;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.NotifyingListImpl;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;


public class EcoreEList extends NotifyingListImpl implements InternalEList, EStructuralFeature.Setting.Internal
{
  protected Class dataClass;
  protected InternalEObject owner;

  public EcoreEList(Class dataClass, InternalEObject owner)
  {
    super();
    this.dataClass = dataClass;
    this.owner = owner;
  }

  protected Object [] newData(int capacity)
  {
    return (Object [])Array.newInstance(dataClass, capacity);
  }

  public Object getNotifier()
  {
    return owner;
  }

  public Object getFeature()
  {
    return getEStructuralFeature();
  }

  public int getFeatureID()
  {
    return getEStructuralFeature().getFeatureID();
  }

  public EStructuralFeature getEStructuralFeature()
  {
    return owner.eClass().getEStructuralFeature(getFeatureID());
  }

  public EStructuralFeature getInverseEStructuralFeature()
  {
    return ((EReference)getEStructuralFeature()).getEOpposite();
  }

  public int getInverseFeatureID()
  {
    return getInverseEStructuralFeature().getFeatureID();
  }

  public Class getInverseFeatureClass()
  {
    return ((EClass)getInverseEStructuralFeature().getEType()).getInstanceClass();
  }

  protected boolean hasManyInverse()
  {
    return false;
  }

  protected boolean hasNavigableInverse()
  {
    return false;
  }

  protected boolean isEObject()
  {
    return true;
  }

  protected boolean isContainment()
  {
    return false;
  }

  protected boolean hasProxies()
  {
    return false;
  }

  protected Object resolve(int index, Object object)
  {
    if (isEObject() && hasProxies())
    {
      EObject resolved = resolveProxy((EObject)object);
      if (resolved != object)
      {
        Object oldObject = data[index];
        assign(index, validate(index, resolved));
        didSet(index, object, oldObject);

        // EATM turn into notification
        //
        // owner.resolved(getEStructuralFeature(), resolved);

        if (isNotificationRequired())
        {
          owner.eNotify(new ENotificationImpl(owner, Notification.RESOLVE, getFeatureID(), object, resolved, index));
        }

        return resolved;
      }
    }
    return object;
  }

  protected EObject resolveProxy(EObject eObject)
  {
    return EcoreUtil.resolve(eObject, owner);
  }

  public Object[] toArray()
  {
    if (hasProxies())
    {
      for (int i = size - 1; i >= 0; --i)
      {
        get(i);
      }
    }
    return super.toArray();
  }

  public Object[] toArray(Object array[])
  {
    if (hasProxies())
    {
      for (int i = size - 1; i >= 0; --i)
      {
        get(i);
      }
    }
    return super.toArray(array);
  }

  protected Notification createNotification(int eventType, Object oldObject, Object newObject, int index)
  {
    return new ENotificationImpl(owner, eventType, getFeatureID(), oldObject, newObject, index);
  }

  protected Notification createNotification(int eventType, boolean oldValue, boolean newValue)
  {
    return new ENotificationImpl(owner, eventType, getFeatureID(), oldValue, newValue);
  }

  /*
   * Javadoc copied from base class.
   */
  protected void dispatchNotification(Notification notification)
  {
    owner.eNotify(notification);
  }

  public List basicList()
  {
    return super.basicList();
  }

  protected boolean isNotificationRequired()
  {
    return owner.eNotificationRequired();
  }

  public NotificationChain inverseAdd(Object object, NotificationChain notifications)
  {
    InternalEObject internalEObject = (InternalEObject) object;
    if (hasNavigableInverse())
    {
      return internalEObject.eInverseAdd
        (owner, 
         getInverseFeatureID(),
         getInverseFeatureClass(),
         notifications);
    }
    else
    {
      return internalEObject.eInverseAdd
        (owner, 
         InternalEObject.EOPPOSITE_FEATURE_BASE - getFeatureID(),
         null,
         notifications);
    }
  }

  public NotificationChain inverseRemove(Object object, NotificationChain notifications)
  {
    InternalEObject internalEObject = (InternalEObject) object;
    if (hasNavigableInverse())
    {
      return internalEObject.eInverseRemove
        (owner, 
         getInverseFeatureID(),
         getInverseFeatureClass(),
         notifications);
    }
    else
    {
      return internalEObject.eInverseRemove
        (owner, 
         InternalEObject.EOPPOSITE_FEATURE_BASE - getFeatureID(),
         null,
         notifications);
    }
  }

  /**
   * Resolve to compare objects but do not modify list
   */
  public boolean contains(Object object)
  {
    if (isEObject())
    {
      if (size > 4)
      {
        if (isContainment())
        {
          if (!(object instanceof EObject)) return false;
          InternalEObject eObject = (InternalEObject)object;
          return 
            eObject.eContainer() == owner && 
              (hasNavigableInverse() ? 
                 eObject.eContainerFeatureID() == getInverseFeatureID() :
                 InternalEObject.EOPPOSITE_FEATURE_BASE - eObject.eContainerFeatureID() == getFeatureID());
        }
        // We can also optimize single valued reverse. 
        //
        else if (hasInverse() && !hasManyInverse())
        {
          return object instanceof EObject && ((EObject)object).eGet(getInverseEStructuralFeature()) == owner;
        }
      }

      boolean result = super.contains(object);
      if (hasProxies() && !result)
      {
        for (int i = 0; i < size; ++i)
        {
          EObject eObject = resolveProxy((EObject)data[i]);
          if (eObject == object)
          {
            return true;
          }
        }
      }
      return result;
    }
    else
    {
      return super.contains(object);
    }
  }

  public int indexOf(Object object)
  {
    int index = super.indexOf(object);
    if (index >= 0)
      return index;

    // EATM This might be better written as a single loop for the EObject case?
    //
    if (isEObject())
    {
      for (int i = 0; i < size; ++i)
      {
        EObject eObject = resolveProxy((EObject)data[i]);
        if (eObject == object)
        {
          return i;
        }
      }
    }

    return -1;
  }

  public int lastIndexOf(Object object)
  {
    int result = super.lastIndexOf(object);
    if (isEObject () && result == -1)
    {
      for (int i = size - 1; i >= 0; --i)
      {
        EObject eObject = EcoreUtil.resolve((EObject)data[i], owner);
        if (eObject == object)
        {
          return i;
        }
      }
    }

    return result;
  }

  public Iterator basicIterator()
  {
    return super.basicIterator();
  }

  public ListIterator basicListIterator()
  {
    return super.basicListIterator();
  }

  public ListIterator basicListIterator(int index)
  {
    return super.basicListIterator(index);
  }

  public EObject getEObject()
  {
    return owner;
  }

  public Object get(boolean resolve)
  {
    return this;
  }

  public void set(Object newValue)
  {
    clear();
    addAll((List)newValue);
  }

  public boolean isSet()
  {
    return !isEmpty();
  }

  public void unset()
  {
    clear();
  }

  public static class UnmodifiableEList 
    extends BasicEList.UnmodifiableEList 
    implements InternalEList, EStructuralFeature.Setting.Internal
  {
    protected InternalEObject owner;
    protected EStructuralFeature eStructuralFeature;

    public UnmodifiableEList(InternalEObject owner, EStructuralFeature eStructuralFeature, int size, Object [] data)
    {
      super(size, data);
      this.owner = owner;
      this.eStructuralFeature = eStructuralFeature;
    }

    public List basicList()
    {
      return super.basicList();
    }

    public Iterator basicIterator()
    {
      return super.basicIterator();
    }

    public ListIterator basicListIterator()
    {
      return super.basicListIterator();
    }

    public ListIterator basicListIterator(int index)
    {
      return super.basicListIterator(index);
    }

    public EObject getEObject()
    {
      return owner;
    }

    public EStructuralFeature getEStructuralFeature()
    {
      return eStructuralFeature;
    }

    public Object get(boolean resolve)
    {
      return this;
    }

    public void set(Object newValue)
    {
      throw new UnsupportedOperationException();
    }

    public boolean isSet()
    {
      return !isEmpty();
    }

    public void unset()
    {
      throw new UnsupportedOperationException();
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications)
    {
      throw new UnsupportedOperationException();
    }

    public NotificationChain basicAdd(Object object, NotificationChain notifications)
    {
      throw new UnsupportedOperationException();
    }
  }
}
