/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.codegen/src/org/eclipse/emf/codegen/jet/JETScriptletGenerator.java, emf.codegen, org.eclipse.dev, 20030620_1105VL
 * @version 1.3 6/20/03
 */
package org.eclipse.emf.codegen.jet;


import java.io.CharArrayWriter;


/**
 * Generator for <% .... %> stuff.
 *
 */
public class JETScriptletGenerator
    implements JETGenerator
{
  protected char[] chars;

  public JETScriptletGenerator(char[] chars) 
  {
    this.chars = chars;
  }

  public String generate() 
  {
    return new String(removeQuotes(chars));
  }

  public static char[] removeQuotes(char [] characters)
  {
    CharArrayWriter writer = new CharArrayWriter();
    for (int i = 0; i < characters.length; ++i)
    {
      if (characters[i] == '%' && characters[i + 1] == '\\' && characters[i + 2] == '\\' && characters[i + 3] == '>')
      {
        writer.write('%');
        writer.write('>');
        i += 3;
      }
      else
      {
        writer.write(characters[i]);
      }
    }

    return writer.toCharArray();
  }
}
