/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.common/src/org/eclipse/emf/common/notify/impl/AdapterImpl.java, emf.common, org.eclipse.dev, 20030620_1105VL
 * @version 1.5 6/20/03
 */
package org.eclipse.emf.common.notify.impl;


import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.Notification;



/**
 * An extensible adapter implementation.
 */
public class AdapterImpl implements Adapter
{
  /**
   * The last notifier set to this adapter.
   */
  protected Notifier target = null;

  /**
   * Creates an instance.
   */
  public AdapterImpl()
  {
  }

  /**
   * Returns <code>false</code>
   * @param type the type.
   * @return <code>false</code>
   */
  public boolean isAdapterForType(Object type)
  {
    return false;
  }

  /**
   * Does nothing; clients may override so that it does something.
   */
  public void notifyChanged(Notification msg)
  {
  }

  /*
   * Javadoc copied from interface.
   */
  public Notifier getTarget()
  {
    return target;
  }

  /*
   * Javadoc copied from interface.
   */
  public void setTarget(Notifier newTarget)
  {
    target = newTarget;
  }
}
