/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/util/EDataTypeEList.java, emf.ecore, org.eclipse.dev, 20030620_1105VL
 * @version 1.10 6/20/03
 */
package org.eclipse.emf.ecore.util;


import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.InternalEObject;


public class EDataTypeEList extends EcoreEList
{
  public static class Unsettable extends EDataTypeEList
  {
    protected boolean isSet;

    public Unsettable(Class dataClass, InternalEObject owner, int featureID)
    {
      super(dataClass, owner, featureID);
    }

    protected void didChange()
    {
      isSet = true;
    }

    public boolean isSet()
    {
      return isSet;
    }

    public void unset()
    {
      super.unset();
      if (isNotificationRequired())
      {
        boolean oldIsSet = isSet;
        isSet = false;
        owner.eNotify(createNotification(Notification.UNSET, oldIsSet, false));
      }
      else
      {
        isSet = false;
      }
    }
  }

  protected final int featureID;

  public EDataTypeEList(Class dataClass, InternalEObject owner, int featureID)
  {
    super(dataClass, owner);
    this.featureID = featureID;
  }

  public int getFeatureID()
  {
    return featureID;
  }

  protected boolean isEObject()
  {
    return false;
  }
}
