/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit/src/org/eclipse/emf/edit/command/CommandActionDelegate.java, emf.edit, org.eclipse.dev, 20030620_1105VL
 * @version 1.4 6/20/03
 */
package org.eclipse.emf.edit.command;


import org.eclipse.emf.common.command.Command;


/**
 * This is the interface used by a CommandAction to delegate all of the set methods of an IAction to a {@link Command}.
 */
public interface CommandActionDelegate
{
  /**
   * This returns whether the action should be enabled.
   */
  public boolean canExecute();

  /**
   * This returns the decoration, if any, of the action.
   */
  public Object getImage();

  /**
   * This returns the menu text, if any, of the action.
   */
  public String getText();

  /**
   * This returns the description, if any, of the action.
   */
  public String getDescription();

  /**
   * This returns the tool tip text, if any, of the action.
   */
  public String getToolTipText();
}
