/**
 * <copyright> 
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.edit/src/org/eclipse/emf/edit/provider/IItemProviderDecorator.java, emf.edit, org.eclipse.dev, 20030620_1105VL
 * @version 1.3 6/20/03
 */
package org.eclipse.emf.edit.provider;



/**
 * This is implemented by an item provider that decorates another item provider.
 */
public interface IItemProviderDecorator 
{
  /**
   * This returns the decorated item provider, which must implement the {@link org.eclipse.emf.edit.provider.IChangeNotifier} interface.
   */
  IChangeNotifier getDecoratedItemProvider();

  /**
   * This set the decorated item provider, which must implement the {@link org.eclipse.emf.edit.provider.IChangeNotifier} interface.
   */
  void setDecoratedItemProvider(IChangeNotifier decoratedItemProvider);
}
