/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore/src/org/eclipse/emf/ecore/EStructuralFeature.java, emf.ecore, org.eclipse.111, 20031020_1612WL
 * @version 1.39 10/20/03
 */
package org.eclipse.emf.ecore;


import org.eclipse.emf.common.notify.NotificationChain;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>EStructural Feature</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#isChangeable <em>Changeable</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#isVolatile <em>Volatile</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#isTransient <em>Transient</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#isUnique <em>Unique</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#getDefaultValueLiteral <em>Default Value Literal</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#getDefaultValue <em>Default Value</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#getLowerBound <em>Lower Bound</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#getUpperBound <em>Upper Bound</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#isMany <em>Many</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#isRequired <em>Required</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#isUnsettable <em>Unsettable</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.EStructuralFeature#getEContainingClass <em>EContaining Class</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature()
 * @model abstract="true"
 * @generated
 */
public interface EStructuralFeature extends ETypedElement
{
  int UNBOUNDED_MULTIPLICITY = -1;

  /**
   * Returns the value of the '<em><b>Transient</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the value of the '<em>Transient</em>' attribute.
   * @see #setTransient(boolean)
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_Transient()
   * @model 
   * @generated
   */
  boolean isTransient();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.EStructuralFeature#isTransient <em>Transient</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Transient</em>' attribute.
   * @see #isTransient()
   * @generated
   */
  void setTransient(boolean value);

  /**
   * Returns the value of the '<em><b>Volatile</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the value of the '<em>Volatile</em>' attribute.
   * @see #setVolatile(boolean)
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_Volatile()
   * @model 
   * @generated
   */
  boolean isVolatile();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.EStructuralFeature#isVolatile <em>Volatile</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Volatile</em>' attribute.
   * @see #isVolatile()
   * @generated
   */
  void setVolatile(boolean value);

  /**
   * Returns the value of the '<em><b>Changeable</b></em>' attribute.
   * The default value is <code>"true"</code>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the value of the '<em>Changeable</em>' attribute.
   * @see #setChangeable(boolean)
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_Changeable()
   * @model default="true"
   * @generated
   */
  boolean isChangeable();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.EStructuralFeature#isChangeable <em>Changeable</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Changeable</em>' attribute.
   * @see #isChangeable()
   * @generated
   */
  void setChangeable(boolean value);

  /**
   * Returns the value of the '<em><b>Default Value Literal</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * It represents the serialized form of the default value.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Default Value Literal</em>' attribute.
   * @see #setDefaultValueLiteral(String)
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_DefaultValueLiteral()
   * @model 
   * @generated
   */
  String getDefaultValueLiteral();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.EStructuralFeature#getDefaultValueLiteral <em>Default Value Literal</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Default Value Literal</em>' attribute.
   * @see #getDefaultValueLiteral()
   * @generated
   */
  void setDefaultValueLiteral(String value);

  /**
   * Returns the value of the '<em><b>Default Value</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * It represents the default value that feature must take on when an
   * explicit value has not been set.  Specifically, it may be non-null if
   * the feature has an {@link ETypedElement#getEType eType}.  If the
   * {@link #getDefaultValueLiteral defaultValueLiteral} is null, it is
   * simply the <code>eType</code>'s intrinsic {@link
   * EClassifier#getDefaultValue default value}.  Otherwise, if the 
   * <code>eType</code> is an {@link EDataType} and the
   * <code>defaultValueLiteral</code> is non-null, it is the object created
   * by the factory's {@link EFactory#createFromString} method when invoked
   * with those two objects as parameters.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Default Value</em>' attribute.
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_DefaultValue()
   * @model transient="true" changeable="false" volatile="true"
   * @generated
   */
  Object getDefaultValue();

  /**
   * A convenience method for setting the '<em><b>Default Value Literal</b></em>' attribute.
   * <p>
   * If the feature has an {@link ETypedElement#getEType eType} that is an
   * {@link EDataType}, the specified <code>value</code> is converted to
   * a string using the factory's {@link EFactory#convertToString} 
   * method, and the {@link #getDefaultValueLiteral defaultValueLiteral} is
   * set to the result.
   * </p>
   * @see #setDefaultValueLiteral
   */
  void setDefaultValue(Object value);

  /**
   * Returns the value of the '<em><b>Unique</b></em>' attribute.
   * The default value is <code>"true"</code>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the value of the '<em>Unique</em>' attribute.
   * @see #setUnique(boolean)
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_Unique()
   * @model default="true"
   * @generated
   */
  boolean isUnique();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.EStructuralFeature#isUnique <em>Unique</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Unique</em>' attribute.
   * @see #isUnique()
   * @generated
   */
  void setUnique(boolean value);

  /**
   * Returns the value of the '<em><b>Lower Bound</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * It represents the minimum number of values that must appear in a valid instance.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Lower Bound</em>' attribute.
   * @see #setLowerBound(int)
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_LowerBound()
   * @model 
   * @generated
   */
  int getLowerBound();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.EStructuralFeature#getLowerBound <em>Lower Bound</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Lower Bound</em>' attribute.
   * @see #getLowerBound()
   * @generated
   */
  void setLowerBound(int value);

  /**
   * Returns the value of the '<em><b>Upper Bound</b></em>' attribute.
   * The default value is <code>"1"</code>.
   * <!-- begin-user-doc -->
   * <p>
   * It represents the maximum number of values that must appear in a valid instance;
   * the value <code>-1</code> represents unbounded.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Upper Bound</em>' attribute.
   * @see #setUpperBound(int)
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_UpperBound()
   * @model default="1"
   * @generated
   */
  int getUpperBound();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.EStructuralFeature#getUpperBound <em>Upper Bound</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Upper Bound</em>' attribute.
   * @see #getUpperBound()
   * @generated
   */
  void setUpperBound(int value);

  /**
   * Returns the value of the '<em><b>Many</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the value of the '<em>Many</em>' attribute.
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_Many()
   * @model transient="true" changeable="false" volatile="true"
   * @generated
   */
  boolean isMany();

  /**
   * Returns the value of the '<em><b>Required</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the value of the '<em>Required</em>' attribute.
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_Required()
   * @model transient="true" changeable="false" volatile="true"
   * @generated
   */
  boolean isRequired();

  /**
   * Returns the value of the '<em><b>Unsettable</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <p>
   * An unsettable attribute explicitly models the state of being set verses being unset
   * and so provides a direct implementation for the reflective {@link #eIsSet eIsSet}.
   * It is only applicable {@link #isMany single-valued} features.
   * One effect of this setting is that,
   * in addition to generating the methods <code>getXyz</code>
   * and <code>setXyz</code> (if the attribute is {@link #isChangeable changeable}),
   * a reflective generator will generate the methods <code>isSetXyz</code> and <code>unsetXyz</code>.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Unsettable</em>' attribute.
   * @see #setUnsettable(boolean)
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_Unsettable()
   * @model 
   * @generated
   */
  boolean isUnsettable();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.EStructuralFeature#isUnsettable <em>Unsettable</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Unsettable</em>' attribute.
   * @see #isUnsettable()
   * @generated
   */
  void setUnsettable(boolean value);

  /**
   * Returns the value of the '<em><b>EContaining Class</b></em>' reference.
   * <!-- begin-user-doc -->
   * <p>
   * It represents the containing class of this feature.
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>EContaining Class</em>' reference.
   * @see org.eclipse.emf.ecore.EcorePackage#getEStructuralFeature_EContainingClass()
   * @model resolveProxies="false" required="true" transient="true" changeable="false" volatile="true"
   * @generated
   */
  EClass getEContainingClass();

  /**
   * <!-- begin-user-doc -->
   * Returns the ID relative to the {@link #getEContainingClass containing} class.
   * @return  the relative ID.
   * <!-- end-user-doc -->
   * @model parameters=""
   * @generated
   */
  int getFeatureID();

  /**
   * <!-- begin-user-doc -->
   * Returns the {@link EClassifier#getInstanceClass instance class} of the {@link #getEContainingClass containing} class.
   * @return the instance class of the containing class.
   * <!-- end-user-doc -->
   * @model parameters=""
   * @generated
   */
  Class getContainerClass();

  /**
   * A representation of a value held by a feature of an object.
   * In the case of a {@link org.eclipse.emf.ecore.InternalEObject#eSetClass dynamic} instance,
   * a setting will be the only actual representation of the object-feature-value association.
   */
  interface Setting
  {
    /**
     * Returns the object holding a value.
     * @return the object holding a value.
     */
    EObject getEObject();

    /**
     * Returns the specific feature holding a value for the object.
     * @return the specific feature holding a value for the object.
     */
    EStructuralFeature getEStructuralFeature();

    /**
     * Returns the value held by the feature of the object;
     * it optionally {@link org.eclipse.emf.ecore.util.EcoreUtil#resolve resolves} the value.
     * @param resolve whether to resolve.
     * @return the value held by the feature of the object.
     * @see EObject#eGet(EStructuralFeature, boolean)
     */
    Object get(boolean resolve);

    /**
     * Set the value held by the feature of the object.
     * @param newValue the newValue.
     * @see EObject#eSet(EStructuralFeature, Object)
     */
    void set(Object newValue);

    /**
     * Returns whether a value is held by the feature of the object.
     * @return whether a value is held by the feature of the object.
     * @see EObject#eIsSet(EStructuralFeature)
     */
    boolean isSet();

    /**
     * Unsets the value held by the feature of the object.
     * @see EObject#eUnset(EStructuralFeature)
     */
    void unset();
  }

  /**
   * Internal API implemented by all features. 
   */
  interface Internal extends EStructuralFeature, InternalEObject
  {
    /**
     * An API for the backing store that holds dynamic values.
     */
    interface DynamicValueHolder
    {
      /**
       * An object use to represent being set to null <code>null</code>  
       * as opposed to having no value and hence being in the default state.
       */
      Object NIL = new Object();

      /**
       * Returns the value of the feature.
       * @param dynamicFeatureID the feature's index in the cached dynamic values.
       * @return the value of the feature.
       */
      Object dynamicGet(int dynamicFeatureID);

      /**
       * Sets the value of the feature to the new value.
       * @param dynamicFeatureID the feature's index in the cached dynamic values.
       * @param newValue the new value for the feature.
       */
      void dynamicSet(int dynamicFeatureID, Object newValue);

      /**
       * Unsets the value of the feature.
       * @param dynamicFeatureID the feature's index in the cached dynamic values.
       */
      void dynamicUnset(int dynamicFeatureID);
    }

    /**
     * An API for delegating reflective access to settings. 
     */
    interface SettingDelegate
    {
      /**
       * Returns a setting that can be used to access the owner's feature.
       * @param owner the owner of the feature.
       * @param settings the owner's array of cached values.
       * @param dynamicFeatureID the feature's index in the owner's cached dynamic values.
       * @return a setting that can be used to access the owner's feature.
       * @see InternalEObject#eSetting(EStructuralFeature)
       */
      Setting dynamicSetting(InternalEObject owner, DynamicValueHolder settings, int dynamicFeatureID);

      /**
       * Returns the value of the feature of this owner.
       * @param owner the owner of the feature.
       * @param settings the owner's array of cached values.
       * @param dynamicFeatureID the feature's index in the owner's cached dynamic values.
       * @param resolve whether to resolve.
       * @return the value of the feature of this owner.
       * @see EObject#eGet(EStructuralFeature, boolean)
       */
      Object dynamicGet(InternalEObject owner, DynamicValueHolder settings, int dynamicFeatureID, boolean resolve);

      /**
       * Sets the value of the given feature of the owner to the new value.
       * @param owner the owner of the feature.
       * @param settings the owner's array of cached values.
       * @param dynamicFeatureID the feature's index in the owner's cached dynamic values.
       * @param newValue the new value for the feature.
       * @see EObject#eSet(EStructuralFeature, Object)
       */
      void dynamicSet(InternalEObject owner, DynamicValueHolder settings, int dynamicFeatureID, Object newValue);

      /**
       * Returns whether the feature of the owner is considered to be set.
       * @param owner the owner of the feature.
       * @param settings the owner's array of cached values.
       * @param dynamicFeatureID the feature's index in the owner's cached dynamic values.
       * @return whether the feature of the owner is considered to be set.
       * @see EObject#eIsSet(EStructuralFeature)
       */
      boolean dynamicIsSet(InternalEObject owner, DynamicValueHolder settings, int dynamicFeatureID);

      /**
       * Unsets the value of the given feature of the owner.
       * @param owner the owner of the feature.
       * @param settings the owner's array of cached values.
       * @param dynamicFeatureID the feature's index in the owner's cached dynamic values.
       * @see EObject#eUnset(EStructuralFeature)
       */
      void dynamicUnset(InternalEObject owner, DynamicValueHolder settings, int dynamicFeatureID);

      /**
       * Adds the object at the other end of a bidirectional reference to the appropriate feature
       * and returns accumulated notifications.
       * @param owner the owner of the feature.
       * @param settings the owner's array of cached values.
       * @param dynamicFeatureID the feature's index in the owner's cached dynamic values.
       * @param otherEnd the object to inverse add.
       * @param notifications the incoming accumulated notifications.
       * @return accumulated notifications.
       * @see InternalEObject#eInverseAdd
       */
      NotificationChain dynamicInverseAdd
        (InternalEObject owner, DynamicValueHolder settings, int dynamicFeatureID, InternalEObject otherEnd, NotificationChain notifications);

      /**
       * Removes the object at the other end of a bidirectional reference from the appropriate feature
       * and returns accumulated notifications.
       * @param owner the owner of the feature.
       * @param settings the owner's array of cached values.
       * @param dynamicFeatureID the feature's index in the owner's cached dynamic values.
       * @param otherEnd the object to inverse remove.
       * @param notifications the incoming accumulated notifications.
       * @return accumulated notifications.
       * @see InternalEObject#eInverseRemove
       */
      NotificationChain dynamicInverseRemove
        (InternalEObject owner, DynamicValueHolder settings, int dynamicFeatureID, InternalEObject otherEnd, NotificationChain notifications);
    }

    /**
     * Returns the delegate for this feature.
     * A default delegate implementation should always be available,
     * so this should never return <code>null</code>.
     * @return the delegate for this feature.
     */
    SettingDelegate getSettingDelegate();

    /**
     * Sets the specialized delegate for this feature.
     * @param settingDelegate the specialized delegate.
     */
    void setSettingDelegate(SettingDelegate settingDelegate);
  }
}
