/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.xmi/src/org/eclipse/emf/ecore/xmi/FeatureNotFoundException.java, emf.ecore.xmi, org.eclipse.111, 20031020_1612WL
 * @version 1.4 10/20/03
 */
package org.eclipse.emf.ecore.xmi;

import org.eclipse.emf.ecore.EObject;

public class FeatureNotFoundException extends XMIException {
    protected String featureName;
    protected EObject object;

	/**
	 * Constructor for FeatureNotFoundException.
	 * @param name
	 * @param object
	 * @param location
	 * @param line
	 * @param column
	 */
	public FeatureNotFoundException(
		String name,
		EObject object,
		String location,
		int line,
		int column) {
		super("Feature '" + name + "' not found.", location, line, column);
		featureName = name;
		this.object = object;
	}
	
	public String getName() {
		return featureName;
	}	
	
	public EObject getObject() {
		return object;
	}	
}
