/**
 * <copyright>
 *
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * plugins/org.eclipse.emf.ecore.xmi/src/org/eclipse/emf/ecore/xmi/IllegalValueException.java, emf.ecore.xmi, org.eclipse.111, 20031020_1612WL
 * @version 1.2 10/20/03
 */
package org.eclipse.emf.ecore.xmi;

import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class IllegalValueException extends XMIException {
	protected EObject object;
	protected EStructuralFeature feature;
	protected Object value;
	
	/**
	 * Constructor for ClassNotFoundException.
	 * @param name
	 * @param factory
	 * @param location
	 * @param line
	 * @param column
	 */
	public IllegalValueException(
		EObject object,
		EStructuralFeature feature,
		Object value,
		Exception emfException,
		String location,
		int line,
		int column) {
		super("Value '" + value + "' is not legal.", emfException, location, line, column);
		this.object  = object;
		this.feature = feature;
		this.value   = value;
	}
	
	public EObject getObject() {
		return object;
	}
	
	public EStructuralFeature getFeature() {
		return feature;
	}
	
	public Object getValue() {
		return value;
	}
}
